/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandNoteLong
extends CommandMultilines2<TimingDiagram> {
    public CommandNoteLong() {
        super(CommandNoteLong.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?note$";
    }

    @Override
    protected CommandExecutionResult executeNow(TimingDiagram diagram, BlocLines lines) {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        String code = line0.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = lines.toDisplay();
        TimeTick now = diagram.getNow();
        player.addNote(now, note, Position.fromString(line0.get("POSITION", 0)));
        return CommandExecutionResult.ok();
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteLong.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(top|bottom)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }
}

