/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeMessage;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import znaishaded.net.sourceforge.plantuml.timingdiagram.command.TimeTickBuilder;

public class CommandTimeMessage
extends SingleLineCommand2<TimingDiagram> {
    public static final String PLAYER_CODE = "([\\p{L}_][\\p{L}0-9_.]*)";

    public CommandTimeMessage() {
        super(CommandTimeMessage.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandTimeMessage.class.getName(), RegexLeaf.start(), new RegexLeaf("PART1", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME1"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ARROW_BODY", "(-+)"), new RegexLeaf("ARROW_STYLE", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_HEAD", "\\>"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("PART2", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME2"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(.*)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        Player player1 = diagram.getPlayer(arg.get("PART1", 0));
        if (player1 == null) {
            return CommandExecutionResult.error("No such element: " + arg.get("PART1", 0));
        }
        Player player2 = diagram.getPlayer(arg.get("PART2", 0));
        if (player2 == null) {
            return CommandExecutionResult.error("No such element: " + arg.get("PART2", 0));
        }
        TimeTick tick1 = TimeTickBuilder.parseTimeTick("TIME1", arg, diagram);
        TimeTick tick2 = TimeTickBuilder.parseTimeTick("TIME2", arg, diagram);
        TimeMessage result = diagram.createTimeMessage(player1, tick1, player2, tick2, arg.get("MESSAGE", 0));
        result.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        return CommandExecutionResult.ok();
    }
}

