/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.api.ApiParametersAnchors;

class ApiParametersCommon {
    static final PluginParamsDefinition paramsDefinition = new PluginParamsDefinition().add("anchorPrefix", PluginParamType.STRING, "prefix to use for individual parameter link anchors", "\"my-api\"").add("title", PluginParamType.STRING, "api parameters title", "\"my api\"").add("small", PluginParamType.BOOLEAN, "use smaller font and width", "true").add("noWrap", PluginParamType.BOOLEAN, "do not wrap long parameter names and instead expand parameters column width to fit", "true").add("wide", PluginParamType.BOOLEAN, "use available horizontal space", "true").add(PluginParamsDefinitionCommon.collapsible);

    ApiParametersCommon() {
    }

    static void validateParams(PluginParamsOpts opts) {
        if (opts.has("collapsible") && !opts.has("title")) {
            throw new IllegalArgumentException("collapsible option requires title present");
        }
    }

    static PluginResult pluginResult(ApiParameters apiParameters, ComponentsRegistry componentsRegistry, PluginParams pluginParams, Path markupPath) {
        PluginParamsOpts opts = pluginParams.getOpts();
        ApiParametersAnchors.registerLocalAnchors(componentsRegistry, markupPath, apiParameters);
        Map<String, Object> props = apiParameters.toMap();
        props.putAll(opts.toMap());
        ApiParametersCommon.validateParams(opts);
        return PluginResult.docElement("ApiParameters", props);
    }
}

