/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.util.List;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.openapi.OpenApi3Parameter;
import org.testingisdocumenting.znai.openapi.OpenApiMarkdownParser;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class OpenApi3ParametersToApiParametersConverter {
    private final OpenApiMarkdownParser parser;
    private final List<OpenApi3Parameter> parameters;
    private final ApiParameters apiParameters;

    public OpenApi3ParametersToApiParametersConverter(OpenApiMarkdownParser parser, String anchorPrefix, List<OpenApi3Parameter> parameters) {
        this.parser = parser;
        this.parameters = parameters;
        this.apiParameters = new ApiParameters(anchorPrefix);
    }

    public ApiParameters convert() {
        this.parameters.forEach(this::convertParameter);
        return this.apiParameters;
    }

    private void convertParameter(OpenApi3Parameter parameter) {
        DocElement docElementFromDescription = this.parser.docElementFromDescription(parameter.getDescription());
        String namePrefix = parameter.getRequired() != null && parameter.getRequired() != false ? "*" : "";
        this.apiParameters.add(parameter.getName() + namePrefix, new ApiLinkedText(parameter.getSchema().renderCombinedType()), docElementFromDescription.contentToListOfMaps(), parameter.getDescription());
    }
}

