/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.reference.DocReferences;

public class ParserHandlersList
implements ParserHandler {
    private final List<ParserHandler> list;

    public ParserHandlersList(ParserHandler ... parsers) {
        this.list = Arrays.asList(parsers);
    }

    @Override
    public void onSectionStart(String title, HeadingProps headingProps) {
        this.list.forEach(h2 -> h2.onSectionStart(title, headingProps));
    }

    @Override
    public void onSectionEnd() {
        this.list.forEach(ParserHandler::onSectionEnd);
    }

    @Override
    public void onSubHeading(int level, String title, HeadingProps headingProps) {
        this.list.forEach(h2 -> h2.onSubHeading(level, title, headingProps));
    }

    @Override
    public void onHardLineBreak() {
        this.list.forEach(ParserHandler::onHardLineBreak);
    }

    @Override
    public void onSoftLineBreak() {
        this.list.forEach(ParserHandler::onSoftLineBreak);
    }

    @Override
    public void onParagraphStart() {
        this.list.forEach(ParserHandler::onParagraphStart);
    }

    @Override
    public void onParagraphEnd() {
        this.list.forEach(ParserHandler::onParagraphEnd);
    }

    @Override
    public void onBulletListStart(char bulletMarker, boolean tight) {
        this.list.forEach(h2 -> h2.onBulletListStart(bulletMarker, tight));
    }

    @Override
    public void onBulletListEnd() {
        this.list.forEach(ParserHandler::onBulletListEnd);
    }

    @Override
    public void onOrderedListStart(char delimiter, int startNumber) {
        this.list.forEach(h2 -> h2.onOrderedListStart(delimiter, startNumber));
    }

    @Override
    public void onOrderedListEnd() {
        this.list.forEach(ParserHandler::onOrderedListEnd);
    }

    @Override
    public void onListItemStart() {
        this.list.forEach(ParserHandler::onListItemStart);
    }

    @Override
    public void onListItemEnd() {
        this.list.forEach(ParserHandler::onListItemEnd);
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        this.list.forEach(h2 -> h2.onTable(tableData));
    }

    @Override
    public void onEmphasisStart() {
        this.list.forEach(ParserHandler::onEmphasisStart);
    }

    @Override
    public void onEmphasisEnd() {
        this.list.forEach(ParserHandler::onEmphasisEnd);
    }

    @Override
    public void onStrongEmphasisStart() {
        this.list.forEach(ParserHandler::onStrongEmphasisStart);
    }

    @Override
    public void onStrongEmphasisEnd() {
        this.list.forEach(ParserHandler::onStrongEmphasisEnd);
    }

    @Override
    public void onStrikeThroughStart() {
        this.list.forEach(ParserHandler::onStrikeThroughStart);
    }

    @Override
    public void onStrikeThroughEnd() {
        this.list.forEach(ParserHandler::onStrikeThroughEnd);
    }

    @Override
    public void onBlockQuoteStart() {
        this.list.forEach(ParserHandler::onBlockQuoteStart);
    }

    @Override
    public void onBlockQuoteEnd() {
        this.list.forEach(ParserHandler::onBlockQuoteEnd);
    }

    @Override
    public void onSimpleText(String value) {
        this.list.forEach(h2 -> h2.onSimpleText(value));
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        this.list.forEach(h2 -> h2.onInlinedCode(inlinedCode, docReferences));
    }

    @Override
    public void onLinkStart(String url) {
        this.list.forEach(h2 -> h2.onLinkStart(url));
    }

    @Override
    public void onLinkEnd() {
        this.list.forEach(ParserHandler::onLinkEnd);
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        this.list.forEach(h2 -> h2.onImage(title, destination, alt));
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        this.list.forEach(h2 -> h2.onSnippet(pluginParams, lang, lineNumber, snippet));
    }

    @Override
    public void onThematicBreak() {
        this.list.forEach(ParserHandler::onThematicBreak);
    }

    @Override
    public void onCustomNodeStart(String nodeName, Map<String, ?> attrs) {
        this.list.forEach(h2 -> h2.onCustomNodeStart(nodeName, attrs));
    }

    @Override
    public void onCustomNode(String nodeName, Map<String, ?> attrs) {
        this.list.forEach(h2 -> h2.onCustomNode(nodeName, attrs));
    }

    @Override
    public void onCustomNodeEnd(String nodeName) {
        this.list.forEach(h2 -> h2.onCustomNodeEnd(nodeName));
    }

    @Override
    public void onDocElement(DocElement docElement) {
        this.list.forEach(h2 -> h2.onDocElement(docElement));
    }

    @Override
    public void onGlobalAnchor(String id) {
        this.list.forEach(h2 -> h2.onGlobalAnchor(id));
    }

    @Override
    public void onGlobalAnchorRefStart(String id) {
        this.list.forEach(h2 -> h2.onGlobalAnchorRefStart(id));
    }

    @Override
    public void onGlobalAnchorRefEnd() {
        this.list.forEach(ParserHandler::onGlobalAnchorRefEnd);
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        this.list.forEach(h2 -> h2.onIncludePlugin(includePlugin, pluginResult));
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        this.list.forEach(h2 -> h2.onFencePlugin(fencePlugin, pluginResult));
    }

    @Override
    public void onInlinedCodePlugin(InlinedCodePlugin inlinedCodePlugin, PluginResult pluginResult) {
        this.list.forEach(h2 -> h2.onInlinedCodePlugin(inlinedCodePlugin, pluginResult));
    }

    @Override
    public void onParsingEnd() {
        this.list.forEach(ParserHandler::onParsingEnd);
    }
}

