/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.docelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class SubHeadingUniqueIdGenerator {
    private final List<LevelId> subheadings = new ArrayList<LevelId>();
    private final Map<String, Integer> usedSubheadingsCount;

    SubHeadingUniqueIdGenerator(String topPrefix) {
        this.subheadings.add(new LevelId(1, topPrefix));
        this.usedSubheadingsCount = new HashMap<String, Integer>();
    }

    void registerSubHeading(Integer level, String id) {
        this.subheadings.removeIf(levelId -> ((LevelId)levelId).level >= level);
        this.subheadings.add(new LevelId(level, id));
    }

    String generateId() {
        String prefix = this.subheadings.stream().map(LevelId::getId).filter(id -> !id.isEmpty()).collect(Collectors.joining("-"));
        Integer count = this.usedSubheadingsCount.get(prefix);
        if (count == null) {
            this.usedSubheadingsCount.put(prefix, 1);
            return prefix;
        }
        this.usedSubheadingsCount.put(prefix, count + 1);
        return prefix + "-" + (count + 1);
    }

    static class LevelId {
        private final Integer level;
        private final String id;

        public LevelId(Integer level, String id) {
            this.level = level;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

