/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.python.Python;
import org.testingisdocumenting.znai.python.PythonClass;
import org.testingisdocumenting.znai.python.PythonFileNameAndRelativeName;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonIncludeResultBuilder;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonParsedFile;
import org.testingisdocumenting.znai.python.PythonUtils;

public class PythonClassIncludePlugin
extends PythonIncludePluginBase {
    private PythonFileNameAndRelativeName fileAndRelativeEntryName;
    private PythonIncludeResultBuilder builder;
    private ParserHandler parserHandler;
    private PythonClass pythonClass;
    private List<PythonClass> pythonBaseClasses;
    private Path markupPath;
    private final Python python = Python.INSTANCE;

    @Override
    public String id() {
        return "python-class";
    }

    @Override
    public IncludePlugin create() {
        return new PythonClassIncludePlugin();
    }

    @Override
    protected String snippetIdToUse() {
        return this.pluginParams.getFreeParam();
    }

    @Override
    protected String fileNameToUse() {
        this.fileAndRelativeEntryName = PythonUtils.findFileNameAndRelativeNameByFullyQualifiedName(this.resourcesResolver, this.pluginParams.getFreeParam());
        return this.fileAndRelativeEntryName.getFileName();
    }

    @Override
    protected String defaultPackageName() {
        return this.fileAndRelativeEntryName.getPackageName();
    }

    @Override
    protected Stream<String> additionalAuxiliaryFileNames() {
        return this.pythonBaseClasses.stream().map(PythonClass::getFileName);
    }

    @Override
    public PythonIncludeResult process(PythonParsedFile parsed, ParserHandler parserHandler, Path markupPath) {
        this.parserHandler = parserHandler;
        this.markupPath = markupPath;
        this.pythonClass = parsed.findClassByName(this.fileAndRelativeEntryName.getRelativeName());
        this.pythonBaseClasses = this.collectAllBaseClasses(this.pythonClass);
        PythonParsedEntry classEntry = parsed.findRequiredEntryByTypeAndName("class", this.fileAndRelativeEntryName.getRelativeName());
        this.builder = new PythonIncludeResultBuilder(this.componentsRegistry, parserHandler, markupPath, this.pluginParams.getFreeParam());
        this.builder.addClassHeader();
        this.builder.addPyDocTextOnly(classEntry);
        this.builder.addBaseClassesLinks(this.pythonBaseClasses);
        this.addPropertiesSectionIfRequired();
        this.addProperties();
        this.pythonBaseClasses.forEach(this::addBaseProperties);
        this.addSignatures(this.pythonClass, false);
        this.pythonBaseClasses.forEach(c -> this.addSignatures((PythonClass)c, true));
        this.addDetails(this.pythonClass);
        return this.builder.build();
    }

    private List<PythonClass> collectAllBaseClasses(PythonClass pythonClass) {
        List<PythonClass> baseClasses = pythonClass.getBaseClasses().stream().map(fullName -> this.python.parseClassOrGetCached(this.resourcesResolver, (String)fullName)).collect(Collectors.toList());
        ArrayList<PythonClass> result = new ArrayList<PythonClass>(baseClasses);
        baseClasses.forEach(pc -> result.addAll(this.collectAllBaseClasses((PythonClass)pc)));
        return result;
    }

    private void addSignatures(PythonClass pythonClass, boolean excludeInit) {
        this.builder.addSubSection(this.pythonBaseClasses.isEmpty() ? "Members" : pythonClass.getName() + " Members");
        this.addMembersSignature(pythonClass.getPackageName(), this.classMethods(pythonClass.getFunctions()));
        this.addMembersSignature(pythonClass.getPackageName(), this.staticMethods(pythonClass.getFunctions()));
        this.addMembersSignature(pythonClass.getPackageName(), this.regularMethods(pythonClass.getFunctions(), excludeInit));
    }

    private void addDetails(PythonClass pythonClass) {
        this.builder.addSubSection(this.pythonBaseClasses.isEmpty() ? "Details" : pythonClass.getName() + " Details");
        this.addMembersDetails(pythonClass.getPackageName(), this.classMethods(pythonClass.getFunctions()));
        this.addMembersDetails(pythonClass.getPackageName(), this.staticMethods(pythonClass.getFunctions()));
        this.addMembersDetails(pythonClass.getPackageName(), this.regularMethods(pythonClass.getFunctions(), false));
    }

    private void addPropertiesSectionIfRequired() {
        if (this.pythonClass.hasProperties() || this.pythonBaseClasses.stream().anyMatch(PythonClass::hasProperties)) {
            this.builder.addSubSection("Properties");
        }
    }

    private void addProperties() {
        this.addProperties(this.pythonClass, this.pythonClass.getBaseClasses().isEmpty() ? "" : this.pythonClass.getName());
    }

    private void addBaseProperties(PythonClass pythonClass) {
        this.addProperties(pythonClass, pythonClass.getName());
    }

    private void addProperties(PythonClass pythonClass, String title) {
        ApiParameters properties = pythonClass.createPropertiesAsApiParameters(this.componentsRegistry.docStructure(), this.componentsRegistry.markdownParser(), this.markupPath);
        if (!properties.isEmpty()) {
            Map<String, Object> props = properties.toMap();
            if (!title.isEmpty()) {
                props.put("title", title);
            }
            this.builder.addSearchText(properties.combinedTextForSearch());
            this.parserHandler.onCustomNode("ApiParameters", props);
        }
    }

    private Stream<PythonParsedEntry> classMethods(List<PythonParsedEntry> memberFunctions) {
        return memberFunctions.stream().filter(PythonParsedEntry::isClassMethod);
    }

    private Stream<PythonParsedEntry> staticMethods(List<PythonParsedEntry> memberFunctions) {
        return memberFunctions.stream().filter(PythonParsedEntry::isStatic);
    }

    private Stream<PythonParsedEntry> regularMethods(List<PythonParsedEntry> memberFunctions, boolean excludeInit) {
        return memberFunctions.stream().filter(e -> !e.isClassMethod() && !e.isStatic() && !e.isPrivate() && (!excludeInit || !e.getName().endsWith(".__init__")));
    }

    private void addMembersSignature(String packageName, Stream<PythonParsedEntry> entries) {
        entries.forEach(entry -> this.builder.addMethodSignature(packageName, (PythonParsedEntry)entry, PythonIncludeResultBuilder.NameRenderOpt.SHORT_NAME, PythonIncludeResultBuilder.ArgsRenderOpt.REMOVE_SELF, PythonIncludeResultBuilder.MarginOpts.DEFAULT, true));
    }

    private void addMembersDetails(String packageName, Stream<PythonParsedEntry> entries) {
        entries.forEach(entry -> {
            this.builder.addEntryHeader(PythonUtils.entityNameFromQualifiedName(entry.getName()));
            String globalAnchorId = PythonUtils.globalAnchorId(packageName + "." + entry.getName());
            this.parserHandler.onGlobalAnchor(globalAnchorId);
            PythonIncludeResultBuilder.MarginOpts marginOpts = entry.getDocString().isEmpty() ? PythonIncludeResultBuilder.MarginOpts.DEFAULT : PythonIncludeResultBuilder.MarginOpts.EXTRA_BOTTOM_MARGIN;
            this.builder.addMethodSignature(packageName, (PythonParsedEntry)entry, PythonIncludeResultBuilder.NameRenderOpt.FULL_NAME, PythonIncludeResultBuilder.ArgsRenderOpt.REMOVE_SELF, marginOpts, false);
            this.builder.addPyDocTextOnly((PythonParsedEntry)entry);
            this.builder.addPyDocParams(packageName, (PythonParsedEntry)entry);
        });
    }
}

