/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.structure.GlobalAnchor;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.website.ProgressReporter;

class WebSiteDocStructure
implements DocStructure {
    private final ComponentsRegistry componentsRegistry;
    private final DocMeta docMeta;
    private TableOfContents toc;
    private final MarkupParsingConfiguration parsingConfiguration;
    private final List<LinkToValidate> collectedExternalLinks;
    private final List<LinkToValidate> collectedLocalLinks;
    private final Map<String, GlobalAnchor> globalAnchorsById;
    private final Map<TocItem, List<String>> localAnchorIdsByTocItem;

    WebSiteDocStructure(ComponentsRegistry componentsRegistry, DocMeta docMeta, TableOfContents toc, MarkupParsingConfiguration parsingConfiguration) {
        this.componentsRegistry = componentsRegistry;
        this.docMeta = docMeta;
        this.toc = toc;
        this.parsingConfiguration = parsingConfiguration;
        this.collectedExternalLinks = new ArrayList<LinkToValidate>();
        this.collectedLocalLinks = new ArrayList<LinkToValidate>();
        this.globalAnchorsById = new HashMap<String, GlobalAnchor>();
        this.localAnchorIdsByTocItem = new HashMap<TocItem, List<String>>();
    }

    void removeGlobalAnchorsForPath(Path path) {
        List<Map.Entry> entriesForPath = this.globalAnchorsById.entrySet().stream().filter(kv -> ((GlobalAnchor)kv.getValue()).getFilePath().equals(path)).collect(Collectors.toList());
        entriesForPath.forEach(kv -> this.globalAnchorsById.remove(kv.getKey()));
    }

    void removeLocalAnchorsForTocItem(TocItem tocItem) {
        this.localAnchorIdsByTocItem.remove(tocItem);
    }

    void removeLinksForPath(Path path) {
        this.collectedExternalLinks.removeIf(linkToValidate -> ((LinkToValidate)linkToValidate).path.equals(path));
        this.collectedLocalLinks.removeIf(linkToValidate -> ((LinkToValidate)linkToValidate).path.equals(path));
    }

    void updateToc(TableOfContents toc) {
        this.toc = toc;
    }

    public void validateCollectedLinks() {
        String localLinksValidation = this.validateLocalLinks();
        String externalLinksValidation = this.validateExternalLinks();
        if (localLinksValidation.isEmpty() && externalLinksValidation.isEmpty()) {
            return;
        }
        String message = Stream.of(localLinksValidation, externalLinksValidation).filter(m3 -> !m3.isEmpty()).collect(Collectors.joining("\n\n"));
        throw new RuntimeException(message + "\n");
    }

    @Override
    public void validateUrl(Path path, String additionalClue, DocUrl docUrl) {
        if (docUrl.isExternalUrl()) {
            if (this.componentsRegistry.docConfig().isValidateExternalLinks()) {
                this.collectedExternalLinks.add(new LinkToValidate(path, additionalClue, docUrl));
            }
        } else {
            this.collectedLocalLinks.add(new LinkToValidate(path, additionalClue, docUrl));
        }
    }

    @Override
    public String createUrl(Path path, DocUrl docUrl) {
        if (docUrl.isExternalUrl()) {
            return docUrl.getUrl();
        }
        if (docUrl.isIndexUrl()) {
            return "/" + this.docMeta.getId() + (docUrl.getAnchorId().isEmpty() ? "" : docUrl.getAnchorIdWithHash());
        }
        return this.fullUrl(this.createUrlBase(path, docUrl) + docUrl.getAnchorIdWithHash());
    }

    @Override
    public String fullUrl(String relativeUrl) {
        return "/" + this.docMeta.getId() + "/" + relativeUrl;
    }

    @Override
    public void registerGlobalAnchor(Path sourcePath, String anchorId) {
        GlobalAnchor globalAnchor = this.globalAnchorsById.get(anchorId);
        if (globalAnchor != null) {
            ProgressReporter.reportWarning("global anchor <" + anchorId + "> specified in " + sourcePath + " is already registered in " + globalAnchor.getFilePath());
        }
        TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, sourcePath);
        String url = this.createUrl(sourcePath, new DocUrl(tocItem.getDirName(), tocItem.getFileNameWithoutExtension(), anchorId));
        this.globalAnchorsById.put(anchorId, new GlobalAnchor(anchorId, sourcePath, url));
    }

    @Override
    public void registerLocalAnchor(Path path, String anchorId) {
        TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path);
        if (tocItem == null) {
            throw new RuntimeException("Can't find TocItem associated with path: " + path);
        }
        List anchors = this.localAnchorIdsByTocItem.computeIfAbsent(tocItem, k -> new ArrayList());
        anchors.add(anchorId);
    }

    @Override
    public String globalAnchorUrl(Path clientPath, String anchorId) {
        GlobalAnchor anchor = this.globalAnchorsById.get(anchorId);
        if (anchor == null) {
            throw new RuntimeException("cannot find global anchor <" + anchorId + "> referenced in " + clientPath + ".\nMake sure you call globalAnchorUrl in lazy evaluated manner to make sure all the global references were registered");
        }
        TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, anchor.getFilePath());
        return this.createUrl(anchor.getFilePath(), new DocUrl(tocItem.getDirName(), tocItem.getFileNameWithoutExtension(), anchorId));
    }

    @Override
    public Optional<String> findGlobalAnchorUrl(String globalAnchorId) {
        GlobalAnchor anchor = this.globalAnchorsById.get(globalAnchorId);
        return anchor == null ? Optional.empty() : Optional.of(anchor.getUrl());
    }

    @Override
    public TableOfContents tableOfContents() {
        return this.toc;
    }

    private String validateLocalLinks() {
        return this.collectedLocalLinks.stream().map(this::validateLocalLink).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
    }

    private String validateExternalLinks() {
        return this.collectedExternalLinks.parallelStream().map(this::validateExternalLink).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
    }

    private Optional<String> validateLocalLink(LinkToValidate link) {
        String anchorId = link.docUrl.getAnchorId();
        TocItem tocItem = this.findTocItemByLink(link);
        if (tocItem == null) {
            return Optional.of(this.createInvalidLinkMessage(link));
        }
        if (anchorId.isEmpty()) {
            return Optional.empty();
        }
        if (this.isValidGlobalAnchor(tocItem, anchorId)) {
            return Optional.empty();
        }
        if (this.isValidLocalAnchor(tocItem, anchorId)) {
            return Optional.empty();
        }
        return Optional.of(this.createInvalidLinkMessage(link));
    }

    private Optional<String> validateExternalLink(LinkToValidate linkToValidate) {
        String url = linkToValidate.docUrl.getUrl();
        int responseCode = this.pingUrlConnection(url, 5000);
        if (responseCode >= 200 && responseCode <= 204 || responseCode == 301) {
            return Optional.empty();
        }
        return Optional.of("can't get data from " + url + ": " + this.checkFileMessage(linkToValidate));
    }

    private int pingUrlConnection(String url, int timeout) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setReadTimeout(timeout);
            connection.setConnectTimeout(timeout);
            connection.addRequestProperty("User-Agent", "Mozilla");
            return connection.getResponseCode();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private TocItem findTocItemByLink(LinkToValidate link) {
        if (link.docUrl.isIndexUrl()) {
            return this.toc.getIndex();
        }
        return link.docUrl.isAnchorOnly() ? this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, link.path) : this.toc.findTocItem(link.docUrl.getDirName(), link.docUrl.getFileName());
    }

    private String createInvalidLinkMessage(LinkToValidate link) {
        String checkFileMessage = this.checkFileMessage(link);
        if (link.docUrl.isAnchorOnly()) {
            return "can't find the anchor " + link.docUrl.getAnchorIdWithHash() + checkFileMessage;
        }
        String url = link.docUrl.getDirName() + "/" + link.docUrl.getFileName() + link.docUrl.getAnchorIdWithHash();
        return "can't find a page associated with: " + url + checkFileMessage;
    }

    private String checkFileMessage(LinkToValidate link) {
        return "\ncheck file: " + link.path + (link.additionalClue.isEmpty() ? "" : ", " + link.additionalClue);
    }

    private boolean isValidGlobalAnchor(TocItem tocItemWithAnchor, String anchorId) {
        GlobalAnchor globalAnchor = this.globalAnchorsById.get(anchorId);
        if (globalAnchor == null) {
            return false;
        }
        TocItem anchorTocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, globalAnchor.getFilePath());
        return tocItemWithAnchor.equals(anchorTocItem);
    }

    private boolean isValidLocalAnchor(TocItem tocItem, String anchorId) {
        List<String> localIds = this.localAnchorIdsByTocItem.get(tocItem);
        return localIds != null && localIds.contains(anchorId);
    }

    private String createUrlBase(Path path, DocUrl docUrl) {
        if (docUrl.isAnchorOnly()) {
            TocItem tocItem = this.parsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path);
            return tocItem == null ? "<should not happen>" : tocItem.getDirName() + "/" + tocItem.getFileNameWithoutExtension();
        }
        return docUrl.getDirName() + "/" + docUrl.getFileName();
    }

    private static class LinkToValidate {
        private final Path path;
        private final String additionalClue;
        private final DocUrl docUrl;

        LinkToValidate(Path path, String additionalClue, DocUrl docUrl) {
            this.path = path;
            this.additionalClue = additionalClue;
            this.docUrl = docUrl;
        }
    }
}

