/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.helpers;

import java.math.BigDecimal;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public abstract class DivisorValidator
extends NumericValidator {
    protected DivisorValidator(String keyword, JsonNode digest) {
        super(keyword, digest);
    }

    @Override
    protected final void validateLong(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        long longValue;
        JsonNode node = data.getInstance().getNode();
        long instanceValue = node.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.common.divisor.nonZeroRemainder").putArgument("value", node).putArgument("divisor", this.number));
    }

    @Override
    protected final void validateDecimal(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode node = data.getInstance().getNode();
        BigDecimal instanceValue = node.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.common.divisor.nonZeroRemainder").putArgument("value", node).putArgument("divisor", this.number));
    }
}

