/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.jayway.jsonpath.spi.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.com.jayway.jsonpath.Configuration;
import znaishaded.com.jayway.jsonpath.TypeRef;
import znaishaded.com.jayway.jsonpath.spi.mapper.MappingProvider;
import znaishaded.org.json.JSONArray;
import znaishaded.org.json.JSONObject;

public class JsonOrgMappingProvider
implements MappingProvider {
    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        if (targetType.equals(Object.class) || targetType.equals(List.class) || targetType.equals(Map.class)) {
            return (T)this.mapToObject(source);
        }
        return (T)source;
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        throw new UnsupportedOperationException("JsonOrg provider does not support TypeRef! Use a Jackson or Gson based provider");
    }

    private Object mapToObject(Object source) {
        if (source instanceof JSONArray) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            JSONArray array = (JSONArray)source;
            for (int i = 0; i < array.length(); ++i) {
                mapped.add(this.mapToObject(array.get(i)));
            }
            return mapped;
        }
        if (source instanceof JSONObject) {
            HashMap<String, Object> mapped = new HashMap<String, Object>();
            JSONObject obj = (JSONObject)source;
            for (Object o : obj.keySet()) {
                String key = o.toString();
                mapped.put(key, this.mapToObject(obj.get(key)));
            }
            return mapped;
        }
        if (source == JSONObject.NULL) {
            return null;
        }
        return source;
    }
}

