/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.deserializer;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import znaishaded.com.fasterxml.jackson.databind.DeserializationFeature;
import znaishaded.com.fasterxml.jackson.databind.JsonMappingException;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.io.swagger.deserializer.SwaggerDeserializer;
import znaishaded.io.swagger.report.Message;
import znaishaded.io.swagger.report.MessageBuilder;
import znaishaded.io.swagger.report.Severity;

public abstract class AbstractSwaggerDeserializer<T>
implements SwaggerDeserializer<T> {
    protected final Class<T> clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected final ObjectMapper objectMapper = new ObjectMapper();

    protected AbstractSwaggerDeserializer() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public T deserialize(JsonNode jsonNode, MessageBuilder messageBuilder) {
        T deserializedObject = null;
        try {
            deserializedObject = this.objectMapper.readValue(jsonNode.traverse(), this.clazz);
        }
        catch (JsonMappingException e) {
            messageBuilder.append(new Message(e.getPathReference(), e.getMessage(), Severity.ERROR));
        }
        catch (IOException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        return deserializedObject;
    }
}

