/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import znaishaded.org.apache.http.client.methods.CloseableHttpResponse;
import znaishaded.org.apache.http.client.methods.HttpGet;
import znaishaded.org.apache.http.client.utils.URIBuilder;
import znaishaded.org.apache.http.impl.client.CloseableHttpClient;
import znaishaded.org.apache.http.impl.client.HttpClients;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public class HttpClient {
    static Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private String baseUrl;
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private CloseableHttpClient httpClient;
    private CloseableHttpResponse response;

    public HttpClient(String url) {
        this.baseUrl = url;
    }

    public void addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public InputStream execute() throws URISyntaxException, IOException {
        this.httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(this.baseUrl);
        for (Map.Entry<String, String> queryParam : this.queryParams.entrySet()) {
            uriBuilder.addParameter(queryParam.getKey(), queryParam.getValue());
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            httpGet.addHeader(header.getKey(), header.getValue());
        }
        this.response = this.httpClient.execute(httpGet);
        return this.response.getEntity().getContent();
    }

    public void close() {
        try {
            this.response.close();
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("failed to close", e);
        }
        try {
            this.httpClient.close();
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("failed to close", e);
        }
    }
}

