/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.models;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.com.fasterxml.jackson.annotation.JsonAnyGetter;
import znaishaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import znaishaded.com.fasterxml.jackson.annotation.JsonIgnore;
import znaishaded.io.swagger.models.ExternalDocs;
import znaishaded.io.swagger.models.Info;
import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.Path;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.models.Scheme;
import znaishaded.io.swagger.models.SecurityRequirement;
import znaishaded.io.swagger.models.Tag;
import znaishaded.io.swagger.models.auth.SecuritySchemeDefinition;
import znaishaded.io.swagger.models.parameters.Parameter;

public class Swagger {
    protected String swagger = "2.0";
    protected Info info;
    protected String host;
    protected String basePath;
    protected List<Tag> tags;
    protected List<Scheme> schemes;
    protected List<String> consumes;
    protected List<String> produces;
    protected List<SecurityRequirement> security;
    protected Map<String, Path> paths;
    protected Map<String, SecuritySchemeDefinition> securityDefinitions;
    protected Map<String, Model> definitions;
    protected Map<String, Parameter> parameters;
    protected Map<String, Response> responses;
    protected ExternalDocs externalDocs;
    protected Map<String, Object> vendorExtensions;

    public Swagger info(Info info) {
        this.setInfo(info);
        return this;
    }

    public Swagger host(String host) {
        this.setHost(host);
        return this;
    }

    public Swagger basePath(String basePath) {
        this.setBasePath(basePath);
        return this;
    }

    public Swagger externalDocs(ExternalDocs value) {
        this.setExternalDocs(value);
        return this;
    }

    public Swagger tags(List<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Swagger tag(Tag tag) {
        this.addTag(tag);
        return this;
    }

    public Swagger schemes(List<Scheme> schemes) {
        this.setSchemes(schemes);
        return this;
    }

    public Swagger scheme(Scheme scheme) {
        this.addScheme(scheme);
        return this;
    }

    public Swagger consumes(List<String> consumes) {
        this.setConsumes(consumes);
        return this;
    }

    public Swagger consumes(String consumes) {
        this.addConsumes(consumes);
        return this;
    }

    public Swagger produces(List<String> produces) {
        this.setProduces(produces);
        return this;
    }

    public Swagger produces(String produces) {
        this.addProduces(produces);
        return this;
    }

    public Swagger paths(Map<String, Path> paths) {
        this.setPaths(paths);
        return this;
    }

    public Swagger path(String key, Path path) {
        if (this.paths == null) {
            this.paths = new LinkedHashMap<String, Path>();
        }
        this.paths.put(key, path);
        return this;
    }

    public Swagger responses(Map<String, Response> responses) {
        this.responses = responses;
        return this;
    }

    public Swagger response(String key, Response response) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, Response>();
        }
        this.responses.put(key, response);
        return this;
    }

    public Swagger parameter(String key, Parameter parameter) {
        this.addParameter(key, parameter);
        return this;
    }

    public Swagger securityDefinition(String name, SecuritySchemeDefinition securityDefinition) {
        this.addSecurityDefinition(name, securityDefinition);
        return this;
    }

    public Swagger model(String name, Model model) {
        this.addDefinition(name, model);
        return this;
    }

    public Swagger security(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
        return this;
    }

    public Swagger vendorExtension(String key, Object extension) {
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.put(key, extension);
        return this;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> schemes) {
        this.schemes = schemes;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        if (!this.schemes.contains((Object)scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Tag getTag(String tagName) {
        Tag tag = null;
        if (this.tags != null && tagName != null) {
            for (Tag existing : this.tags) {
                if (!existing.getName().equals(tagName)) continue;
                tag = existing;
                break;
            }
        }
        return tag;
    }

    public void addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        if (tag != null && tag.getName() != null && this.getTag(tag.getName()) == null) {
            this.tags.add(tag);
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void addConsumes(String consumes) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        if (!this.consumes.contains(consumes)) {
            this.consumes.add(consumes);
        }
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void addProduces(String produces) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        if (!this.produces.contains(produces)) {
            this.produces.add(produces);
        }
    }

    public Map<String, Path> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, Path> paths) {
        this.paths = paths;
    }

    public Path getPath(String path) {
        if (this.paths == null) {
            return null;
        }
        return this.paths.get(path);
    }

    public Map<String, SecuritySchemeDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(Map<String, SecuritySchemeDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public void addSecurityDefinition(String name, SecuritySchemeDefinition securityDefinition) {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new LinkedHashMap<String, SecuritySchemeDefinition>();
        }
        this.securityDefinitions.put(name, securityDefinition);
    }

    @JsonIgnore
    @Deprecated
    public List<SecurityRequirement> getSecurityRequirement() {
        return this.security;
    }

    @JsonIgnore
    @Deprecated
    public void setSecurityRequirement(List<SecurityRequirement> securityRequirements) {
        this.security = securityRequirements;
    }

    @JsonIgnore
    @Deprecated
    public void addSecurityDefinition(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement);
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRequirement> securityRequirements) {
        this.security = securityRequirements;
    }

    public void addSecurity(SecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(securityRequirement);
    }

    public Map<String, Model> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map<String, Model> definitions) {
        this.definitions = definitions;
    }

    public void addDefinition(String key, Model model) {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Model>();
        }
        this.definitions.put(key, model);
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public Parameter getParameter(String parameter) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(parameter);
    }

    public void addParameter(String key, Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Parameter>();
        }
        this.parameters.put(key, parameter);
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> responses) {
        this.responses = responses;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs value) {
        this.externalDocs = value;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtension(name, value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + (this.consumes == null ? 0 : this.consumes.hashCode());
        result = 31 * result + (this.definitions == null ? 0 : this.definitions.hashCode());
        result = 31 * result + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        result = 31 * result + (this.produces == null ? 0 : this.produces.hashCode());
        result = 31 * result + (this.responses == null ? 0 : this.responses.hashCode());
        result = 31 * result + (this.schemes == null ? 0 : this.schemes.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.securityDefinitions == null ? 0 : this.securityDefinitions.hashCode());
        result = 31 * result + (this.swagger == null ? 0 : this.swagger.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Swagger other = (Swagger)obj;
        if (this.basePath == null ? other.basePath != null : !this.basePath.equals(other.basePath)) {
            return false;
        }
        if (this.consumes == null ? other.consumes != null : !this.consumes.equals(other.consumes)) {
            return false;
        }
        if (this.definitions == null ? other.definitions != null : !this.definitions.equals(other.definitions)) {
            return false;
        }
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.paths == null ? other.paths != null : !this.paths.equals(other.paths)) {
            return false;
        }
        if (this.produces == null ? other.produces != null : !this.produces.equals(other.produces)) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        if (this.schemes == null ? other.schemes != null : !this.schemes.equals(other.schemes)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.securityDefinitions == null ? other.securityDefinitions != null : !this.securityDefinitions.equals(other.securityDefinitions)) {
            return false;
        }
        if (this.swagger == null ? other.swagger != null : !this.swagger.equals(other.swagger)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.vendorExtensions == null ? other.vendorExtensions != null : !this.vendorExtensions.equals(other.vendorExtensions));
    }

    public Swagger vendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions == null) {
            return this;
        }
        if (this.vendorExtensions == null) {
            this.vendorExtensions = new LinkedHashMap<String, Object>();
        }
        this.vendorExtensions.putAll(vendorExtensions);
        return this;
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }
}

