/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.processors;

import java.util.List;
import znaishaded.io.swagger.models.Operation;
import znaishaded.io.swagger.models.RefResponse;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.models.Responses;
import znaishaded.io.swagger.models.Swagger;
import znaishaded.io.swagger.models.parameters.Parameter;
import znaishaded.io.swagger.parser.ResolverCache;
import znaishaded.io.swagger.parser.processors.ParameterProcessor;
import znaishaded.io.swagger.parser.processors.ResponseProcessor;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.responseProcessor = new ResponseProcessor(cache, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Responses responses = operation.getResponsesObject();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                Response response = (Response)responses.get(responseCode);
                if (response == null) continue;
                if (response instanceof RefResponse) {
                    RefResponse refResponse = (RefResponse)response;
                    this.responseProcessor.processResponse(response);
                    Response resolvedResponse = this.cache.loadRef(refResponse.get$ref(), refResponse.getRefFormat(), Response.class);
                    if (resolvedResponse != null) {
                        response = resolvedResponse;
                        responses.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response);
            }
        }
    }
}

