/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.sstore.impl;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.shareddata.Shareable;
import znaishaded.io.vertx.core.shareddata.impl.ClusterSerializable;
import znaishaded.io.vertx.ext.auth.PRNG;
import znaishaded.io.vertx.ext.web.impl.Utils;
import znaishaded.io.vertx.ext.web.sstore.AbstractSession;

public class SharedDataSessionImpl
extends AbstractSession
implements ClusterSerializable,
Shareable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;

    public SharedDataSessionImpl() {
    }

    public SharedDataSessionImpl(PRNG random) {
        super(random);
    }

    public SharedDataSessionImpl(PRNG random, long timeout, int length) {
        super(random, timeout, length);
    }

    @Override
    public void writeToBuffer(Buffer buff) {
        byte[] bytes = this.id().getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        Buffer dataBuf = this.writeDataToBuffer();
        buff.appendBuffer(dataBuf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.setId(new String(bytes, UTF8));
        this.setTimeout(buffer.getLong(pos += len));
        this.setLastAccessed(buffer.getLong(pos += 8));
        this.setVersion(buffer.getInt(pos += 8));
        int start = pos += 4;
        int end = pos = this.readDataFromBuffer(pos, buffer);
        return pos;
    }

    private Buffer writeDataToBuffer() {
        Buffer buffer = Buffer.buffer();
        if (this.isEmpty()) {
            buffer.appendInt(0);
        } else {
            Map<String, Object> data = this.data();
            buffer.appendInt(data.size());
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                byte[] bytes;
                String key = entry.getKey();
                byte[] keyBytes = key.getBytes(UTF8);
                buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                Object val = entry.getValue();
                if (val instanceof Long) {
                    buffer.appendByte((byte)1).appendLong((Long)val);
                    continue;
                }
                if (val instanceof Integer) {
                    buffer.appendByte((byte)2).appendInt((Integer)val);
                    continue;
                }
                if (val instanceof Short) {
                    buffer.appendByte((byte)3).appendShort((Short)val);
                    continue;
                }
                if (val instanceof Byte) {
                    buffer.appendByte((byte)4).appendByte((Byte)val);
                    continue;
                }
                if (val instanceof Double) {
                    buffer.appendByte((byte)5).appendDouble((Double)val);
                    continue;
                }
                if (val instanceof Float) {
                    buffer.appendByte((byte)6).appendFloat(((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Character) {
                    buffer.appendByte((byte)7).appendShort((short)((Character)val).charValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    buffer.appendByte((byte)8).appendByte((byte)((Boolean)val != false ? 1 : 0));
                    continue;
                }
                if (val instanceof String) {
                    bytes = ((String)val).getBytes(UTF8);
                    buffer.appendByte((byte)9).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof Buffer) {
                    Buffer buff = (Buffer)val;
                    buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                    continue;
                }
                if (val instanceof byte[]) {
                    bytes = (byte[])val;
                    buffer.appendByte((byte)11).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof ClusterSerializable) {
                    buffer.appendByte((byte)13);
                    String className = val.getClass().getName();
                    byte[] classNameBytes = className.getBytes(UTF8);
                    buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                    ((ClusterSerializable)val).writeToBuffer(buffer);
                    continue;
                }
                if (val == null) continue;
                throw new IllegalStateException("Invalid type for data in session: " + val.getClass());
            }
        }
        return buffer;
    }

    private int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries = buffer.getInt(pos);
            pos += 4;
            if (entries > 0) {
                ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>(entries);
                for (int i = 0; i < entries; ++i) {
                    Object val;
                    int keylen = buffer.getInt(pos);
                    byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                    pos += keylen;
                    String key = new String(keyBytes, UTF8);
                    byte type = buffer.getByte(pos++);
                    switch (type) {
                        case 1: {
                            val = buffer.getLong(pos);
                            pos += 8;
                            break;
                        }
                        case 2: {
                            val = buffer.getInt(pos);
                            pos += 4;
                            break;
                        }
                        case 3: {
                            val = buffer.getShort(pos);
                            pos += 2;
                            break;
                        }
                        case 4: {
                            val = buffer.getByte(pos);
                            ++pos;
                            break;
                        }
                        case 6: {
                            val = Float.valueOf(buffer.getFloat(pos));
                            pos += 4;
                            break;
                        }
                        case 5: {
                            val = buffer.getDouble(pos);
                            pos += 8;
                            break;
                        }
                        case 7: {
                            short s2 = buffer.getShort(pos);
                            pos += 2;
                            val = Character.valueOf((char)s2);
                            break;
                        }
                        case 8: {
                            byte b = buffer.getByte(pos);
                            ++pos;
                            val = b == 1;
                            break;
                        }
                        case 9: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = new String(bytes, UTF8);
                            pos += len;
                            break;
                        }
                        case 10: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = Buffer.buffer(bytes);
                            pos += len;
                            break;
                        }
                        case 11: {
                            int len = buffer.getInt(pos);
                            val = buffer.getBytes(pos += 4, pos + len);
                            pos += len;
                            break;
                        }
                        case 13: {
                            int classNameLen = buffer.getInt(pos);
                            byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                            pos += classNameLen;
                            String className = new String(classNameBytes, UTF8);
                            Class<?> clazz = Utils.getClassLoader().loadClass(className);
                            if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                                throw new ClassCastException(new String(classNameBytes) + " is not assignable from ClusterSerializable");
                            }
                            ClusterSerializable obj = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            pos = obj.readFromBuffer(pos, buffer);
                            val = obj;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid serialized type: " + type);
                        }
                    }
                    data.put(key, val);
                }
                this.setData(data);
            }
            return pos;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new VertxException(e);
        }
    }
}

