/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.ErrorUmlType;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import znaishaded.net.sourceforge.plantuml.api.PSystemFactory;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.board.BoardDiagramFactory;
import znaishaded.net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.creole.legacy.PSystemCreoleFactory;
import znaishaded.net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import znaishaded.net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import znaishaded.net.sourceforge.plantuml.directdot.PSystemDotFactory;
import znaishaded.net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import znaishaded.net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import znaishaded.net.sourceforge.plantuml.donors.PSystemSkinparameterListFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemEggFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemPathFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import znaishaded.net.sourceforge.plantuml.emoji.PSystemListEmojiFactory;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;
import znaishaded.net.sourceforge.plantuml.error.PSystemErrorUtils;
import znaishaded.net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import znaishaded.net.sourceforge.plantuml.font.PSystemListFontsFactory;
import znaishaded.net.sourceforge.plantuml.gitlog.GitDiagramFactory;
import znaishaded.net.sourceforge.plantuml.hcl.HclDiagramFactory;
import znaishaded.net.sourceforge.plantuml.help.HelpFactory;
import znaishaded.net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import znaishaded.net.sourceforge.plantuml.jsondiagram.JsonDiagramFactory;
import znaishaded.net.sourceforge.plantuml.math.PSystemLatexFactory;
import znaishaded.net.sourceforge.plantuml.math.PSystemMathFactory;
import znaishaded.net.sourceforge.plantuml.mindmap.MindMapDiagramFactory;
import znaishaded.net.sourceforge.plantuml.nwdiag.NwDiagramFactory;
import znaishaded.net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import znaishaded.net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import znaishaded.net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagramFactory;
import znaishaded.net.sourceforge.plantuml.salt.PSystemSaltFactory2;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import znaishaded.net.sourceforge.plantuml.sprite.ListSpriteDiagramFactory;
import znaishaded.net.sourceforge.plantuml.sprite.PSystemListInternalSpritesFactory;
import znaishaded.net.sourceforge.plantuml.sprite.StdlibDiagramFactory;
import znaishaded.net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import znaishaded.net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import znaishaded.net.sourceforge.plantuml.version.License;
import znaishaded.net.sourceforge.plantuml.version.PSystemLicenseFactory;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersionFactory;
import znaishaded.net.sourceforge.plantuml.wbs.WBSDiagramFactory;
import znaishaded.net.sourceforge.plantuml.wire.WireDiagramFactory;
import znaishaded.net.sourceforge.plantuml.yaml.YamlDiagramFactory;

public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();
    private static final List<PSystemFactory> factories = new ArrayList<PSystemFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(ThemeStyle style, ISkinSimple skinParam, List<StringLocated> source, List<StringLocated> rawSource) {
        long now = System.currentTimeMillis();
        Object result = null;
        try {
            DiagramType type = DiagramType.getTypeFromArobaseStart(source.get(0).getString());
            UmlSource umlSource = UmlSource.createWithRaw(source, type == DiagramType.UML, rawSource);
            for (StringLocated s2 : source) {
                if (s2.getPreprocessorError() == null) continue;
                assert (false);
                Log.error("Preprocessor Error: " + s2.getPreprocessorError());
                ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, s2.getPreprocessorError(), 0, s2.getLocation());
                PSystemError pSystemError = PSystemErrorUtils.buildV2(umlSource, err, Collections.emptyList(), source);
                return pSystemError;
            }
            DiagramType diagramType = umlSource.getDiagramType();
            ArrayList<PSystemError> errors = new ArrayList<PSystemError>();
            for (PSystemFactory systemFactory : factories) {
                if (diagramType != systemFactory.getDiagramType()) continue;
                Diagram sys = systemFactory.createSystem(style, umlSource, skinParam);
                if (this.isOk(sys)) {
                    result = sys;
                    Diagram diagram = sys;
                    return diagram;
                }
                errors.add((PSystemError)sys);
            }
            Object object = result = PSystemErrorUtils.merge(errors);
            return object;
        }
        finally {
            if (result != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - now, result.getClass());
            }
            Log.info("Compilation duration " + (System.currentTimeMillis() - now));
            RegexConcat.printCacheInfo();
        }
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }

    static {
        factories.add(new PSystemWelcomeFactory());
        factories.add(new PSystemColorsFactory());
        factories.add(new SequenceDiagramFactory());
        factories.add(new ClassDiagramFactory());
        factories.add(new ActivityDiagramFactory());
        factories.add(new DescriptionDiagramFactory());
        factories.add(new StateDiagramFactory());
        factories.add(new ActivityDiagramFactory3());
        factories.add(new BpmDiagramFactory(DiagramType.BPM));
        factories.add(new PSystemLicenseFactory());
        factories.add(new PSystemVersionFactory());
        factories.add(new PSystemDonorsFactory());
        factories.add(new PSystemSkinparameterListFactory());
        factories.add(new PSystemListFontsFactory());
        factories.add(new PSystemListEmojiFactory());
        factories.add(new PSystemOpenIconicFactory());
        factories.add(new PSystemListOpenIconicFactory());
        factories.add(new PSystemListInternalSpritesFactory());
        factories.add(new PSystemSaltFactory2(DiagramType.SALT));
        factories.add(new PSystemSaltFactory2(DiagramType.UML));
        factories.add(new PSystemDotFactory(DiagramType.DOT));
        factories.add(new PSystemDotFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory(DiagramType.NW));
        factories.add(new NwDiagramFactory(DiagramType.UML));
        factories.add(new MindMapDiagramFactory());
        factories.add(new WBSDiagramFactory());
        factories.add(new PSystemDitaaFactory(DiagramType.DITAA));
        factories.add(new PSystemDitaaFactory(DiagramType.UML));
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            factories.add(new PSystemJcckitFactory(DiagramType.UML));
            factories.add(new PSystemSudokuFactory());
        }
        factories.add(new PSystemDefinitionFactory());
        factories.add(new ListSpriteDiagramFactory());
        factories.add(new StdlibDiagramFactory());
        factories.add(new PSystemMathFactory(DiagramType.MATH));
        factories.add(new PSystemLatexFactory(DiagramType.LATEX));
        factories.add(new PSystemCreoleFactory());
        factories.add(new PSystemEggFactory());
        factories.add(new PSystemAppleTwoFactory());
        factories.add(new PSystemRIPFactory());
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            factories.add(new PSystemPathFactory());
        }
        factories.add(new PSystemOregonFactory());
        factories.add(new PSystemCharlieFactory());
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemXearthFactory());
        }
        factories.add(new GanttDiagramFactory(DiagramType.GANTT));
        factories.add(new GanttDiagramFactory(DiagramType.UML));
        GanttDiagramFactory.clearCache();
        factories.add(new FlowDiagramFactory());
        factories.add(new PSystemDedicationFactory());
        factories.add(new TimingDiagramFactory());
        factories.add(new HelpFactory());
        factories.add(new WireDiagramFactory());
        factories.add(new JsonDiagramFactory());
        factories.add(new GitDiagramFactory());
        factories.add(new BoardDiagramFactory());
        factories.add(new YamlDiagramFactory());
        factories.add(new HclDiagramFactory());
    }
}

