/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import znaishaded.net.sourceforge.plantuml.code.AsciiEncoder;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class SignatureUtils {
    public static synchronized byte[] salting(String pass, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int iterations = 500;
        int keyLength = 512;
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(pass.toCharArray(), salt, 500, 512);
        SecretKey key = skf.generateSecret(spec);
        byte[] tmp = key.getEncoded();
        return tmp;
    }

    public static String getSignature(String s2) {
        try {
            byte[] digest = SignatureUtils.getMD5raw(s2);
            return SignatureUtils.toString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String toString(byte[] data) {
        AsciiEncoder coder = new AsciiEncoder();
        return coder.encode(data);
    }

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getMD5Hex(String s2) {
        try {
            byte[] digest = SignatureUtils.getMD5raw(s2);
            assert (digest.length == 16);
            return SignatureUtils.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSHA512Hex(String s2) {
        try {
            byte[] digest = SignatureUtils.getSHA512raw(s2);
            assert (digest.length == 64);
            return SignatureUtils.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static synchronized byte[] getMD5raw(String s2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest msgDigest = MessageDigest.getInstance("MD5");
        msgDigest.update(s2.getBytes(StandardCharsets.UTF_8));
        return msgDigest.digest();
    }

    public static byte[] getSHA512raw(String s2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return SignatureUtils.getSHA512raw(s2.getBytes(StandardCharsets.UTF_8));
    }

    public static synchronized byte[] getSHA512raw(byte[] data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
        msgDigest.update(data);
        return msgDigest.digest();
    }

    public static String getSignatureSha512(SFile f) throws IOException {
        try (InputStream is = f.openFile();){
            String string = SignatureUtils.getSignatureSha512(is);
            return string;
        }
    }

    public static synchronized String getSignatureSha512(InputStream is) throws IOException {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
            int read = 0;
            while ((read = is.read()) != -1) {
                msgDigest.update((byte)read);
            }
            byte[] digest = msgDigest.digest();
            return SignatureUtils.toString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSignatureWithoutImgSrc(String s2) {
        s2 = SignatureUtils.getSignature(SignatureUtils.purge(s2));
        return s2;
    }

    public static String purge(String s2) {
        String regex = "(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>";
        s2 = s2.replaceAll("(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>", "<img src=\"$1$2\"/>");
        String regex2 = "(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"";
        s2 = s2.replaceAll("(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"", "image=\"$1$2\"");
        return s2;
    }

    public static synchronized String getSignature(SFile f) throws IOException {
        String string;
        block11: {
            InputStream is = f.openFile();
            try {
                MessageDigest msgDigest = MessageDigest.getInstance("MD5");
                if (is == null) {
                    throw new FileNotFoundException();
                }
                int read = -1;
                while ((read = is.read()) != -1) {
                    msgDigest.update((byte)read);
                }
                byte[] digest = msgDigest.digest();
                string = SignatureUtils.toString(digest);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    throw new UnsupportedOperationException(e);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    throw new UnsupportedOperationException(e);
                }
            }
            is.close();
        }
        return string;
    }
}

