/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.AlignmentParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.style.Styleable;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileWithNoteOpale
extends AbstractFtile
implements Stencil,
Styleable {
    private final Ftile tile;
    private final Opale opale;
    private final VerticalAlignment verticalAlignment;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlaneNote != null) {
            HashSet<Swimlane> result = new HashSet<Swimlane>(this.tile.getSwimlanes());
            result.add(this.swimlaneNote);
            return Collections.unmodifiableSet(result);
        }
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    public static Ftile create(Ftile tile, Collection<PositionedNote> notes, ISkinParam skinParam, boolean withLink, VerticalAlignment verticalAlignment) {
        if (notes.size() > 1) {
            return new FtileWithNotes(tile, notes, skinParam, verticalAlignment);
        }
        if (notes.size() == 0) {
            throw new IllegalArgumentException();
        }
        return new FtileWithNoteOpale(tile, notes.iterator().next(), skinParam, withLink, verticalAlignment);
    }

    private FtileWithNoteOpale(Ftile tile, PositionedNote note, ISkinParam skinParam, boolean withLink, VerticalAlignment verticalAlignment) {
        super(tile.skinParam());
        this.verticalAlignment = verticalAlignment;
        this.swimlaneNote = note.getSwimlaneNote();
        if (note.getColors() != null) {
            skinParam = note.getColors().mute(skinParam);
        }
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Style style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        UStroke stroke = style.getStroke();
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = Parser.build(fc, align, skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, stroke);
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, withLink, stroke);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double yForFtile = (dimTotal.getHeight() - ((Dimension2D)dimTile).getHeight()) / 2.0;
        double marge = this.notePosition == NotePosition.LEFT ? dimNote.getWidth() + 20.0 : 0.0;
        return new UTranslate(marge, yForFtile);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile) {
            return new UTranslate();
        }
        return super.getTranslateFor(child, stringBounder);
    }

    private UTranslate getTranslateForOpale(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        double yForNote = this.verticalAlignment == VerticalAlignment.CENTER ? (((Dimension2D)dimTotal).getHeight() - dimNote.getHeight()) / 2.0 : 0.0;
        if (this.notePosition == NotePosition.LEFT) {
            return UTranslate.dy(yForNote);
        }
        double dx = ((Dimension2D)dimTotal).getWidth() - dimNote.getWidth();
        return new UTranslate(dx, yForNote);
    }

    @Override
    public void drawU(UGraphic ug) {
        Swimlane intoSw = ug instanceof UGraphicInterceptorOneSwimlane ? ((UGraphicInterceptorOneSwimlane)ug).getSwimlane() : null;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        if (this.notePosition == NotePosition.LEFT) {
            Direction strategy = Direction.RIGHT;
            Point2D.Double pp1 = new Point2D.Double(dimNote.getWidth(), dimNote.getHeight() / 2.0);
            Point2D.Double pp2 = new Point2D.Double(dimNote.getWidth() + 20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        } else {
            Direction strategy = Direction.LEFT;
            Point2D.Double pp1 = new Point2D.Double(0.0, dimNote.getHeight() / 2.0);
            Point2D.Double pp2 = new Point2D.Double(-20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        }
        if (!(ug instanceof UGraphicInterceptorOneSwimlane) || this.swimlaneNote == null || intoSw == this.swimlaneNote) {
            this.opale.drawU(ug.apply(this.getTranslateForOpale(ug)));
        }
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double height = Math.max(dimNote.getHeight(), ((Dimension2D)dimTile).getHeight());
        return new Dimension2DDouble(((Dimension2D)dimTile).getWidth() + 1.0 * dimNote.getWidth() + 20.0, height);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

