/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.brotli;

import java.nio.ByteBuffer;

final class Transform {
    static final int NUM_TRANSFORMS = 121;
    private static final int[] TRANSFORMS = new int[363];
    private static final byte[] PREFIX_SUFFIX = new byte[217];
    private static final int[] PREFIX_SUFFIX_HEADS = new int[51];
    private static final String PREFIX_SUFFIX_SRC = "# #s #, #e #.# the #.com/#\u00c2\u00a0# of # and # in # to #\"#\">#\n#]# for # a # that #. # with #'# from # by #. The # on # as # is #ing #\n\t#:#ed #(# at #ly #=\"# of the #. This #,# not #er #al #='#ful #ive #less #est #ize #ous #";
    private static final String TRANSFORMS_SRC = "     !! ! ,  *!  &!  \" !  ) *   * -  ! # !  #!*!  +  ,$ !  -  %  .  / #   0  1 .  \"   2  3!*   4%  ! # /   5  6  7  8 0  1 &   $   9 +   :  ;  < '  !=  >  ?! 4  @ 4  2  &   A *# (   B  C& ) %  ) !*# *-% A +! *.  D! %'  & E *6  F  G% ! *A *%  H! D  I!+!  J!+   K +- *4! A  L!*4  M  N +6  O!*% +.! K *G  P +%(  ! G *D +D  Q +# *K!*G!+D!+# +G +A +4!+% +K!+4!*D!+K!*K";

    Transform() {
    }

    private static void unpackTransforms(byte[] prefixSuffix, int[] prefixSuffixHeads, int[] transforms, String prefixSuffixSrc, String transformsSrc) {
        int i;
        int n = prefixSuffixSrc.length();
        int index = 1;
        for (i = 0; i < n; ++i) {
            char c = prefixSuffixSrc.charAt(i);
            prefixSuffix[i] = (byte)c;
            if (c != '#') continue;
            prefixSuffixHeads[index++] = i + 1;
            prefixSuffix[i] = 0;
        }
        for (i = 0; i < 363; ++i) {
            transforms[i] = transformsSrc.charAt(i) - 32;
        }
    }

    static int transformDictionaryWord(byte[] dst, int dstOffset, ByteBuffer data, int wordOffset, int len, int transformIndex) {
        int omitFirst;
        int offset = dstOffset;
        int transformOffset = 3 * transformIndex;
        int transformPrefix = PREFIX_SUFFIX_HEADS[TRANSFORMS[transformOffset]];
        int transformType = TRANSFORMS[transformOffset + 1];
        int transformSuffix = PREFIX_SUFFIX_HEADS[TRANSFORMS[transformOffset + 2]];
        while (PREFIX_SUFFIX[transformPrefix] != 0) {
            dst[offset++] = PREFIX_SUFFIX[transformPrefix++];
        }
        int n = omitFirst = transformType >= 12 ? transformType - 11 : 0;
        if (omitFirst > len) {
            omitFirst = len;
        }
        wordOffset += omitFirst;
        len -= omitFirst;
        for (int i = len -= transformType <= 9 ? transformType : 0; i > 0; --i) {
            dst[offset++] = data.get(wordOffset++);
        }
        if (transformType == 11 || transformType == 10) {
            int uppercaseOffset = offset - len;
            if (transformType == 10) {
                len = 1;
            }
            while (len > 0) {
                int tmp = dst[uppercaseOffset] & 0xFF;
                if (tmp < 192) {
                    if (tmp >= 97 && tmp <= 122) {
                        int n2 = uppercaseOffset;
                        dst[n2] = (byte)(dst[n2] ^ 0x20);
                    }
                    ++uppercaseOffset;
                    --len;
                    continue;
                }
                if (tmp < 224) {
                    int n3 = uppercaseOffset + 1;
                    dst[n3] = (byte)(dst[n3] ^ 0x20);
                    uppercaseOffset += 2;
                    len -= 2;
                    continue;
                }
                int n4 = uppercaseOffset + 2;
                dst[n4] = (byte)(dst[n4] ^ 5);
                uppercaseOffset += 3;
                len -= 3;
            }
        }
        while (PREFIX_SUFFIX[transformSuffix] != 0) {
            dst[offset++] = PREFIX_SUFFIX[transformSuffix++];
        }
        return offset - dstOffset;
    }

    static {
        Transform.unpackTransforms(PREFIX_SUFFIX, PREFIX_SUFFIX_HEADS, TRANSFORMS, PREFIX_SUFFIX_SRC, TRANSFORMS_SRC);
    }
}

