/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code.deflate;

import java.io.IOException;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.code.deflate.OutputStreamProtected;

final class ByteHistory {
    private byte[] data;
    private int index;

    public ByteHistory(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.data = new byte[size];
        this.index = 0;
    }

    public void append(int b) {
        if (this.index < 0 || this.index >= this.data.length) {
            throw new IllegalStateException();
        }
        this.data[this.index] = (byte)b;
        this.index = (this.index + 1) % this.data.length;
    }

    public void copy(int dist, int len, OutputStreamProtected out) throws IOException {
        Objects.requireNonNull(out);
        if (len < 0 || dist < 1 || dist > this.data.length) {
            throw new IllegalArgumentException();
        }
        int readIndex = (this.index - dist + this.data.length) % this.data.length;
        if (readIndex < 0 || readIndex >= this.data.length) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < len; ++i) {
            byte b = this.data[readIndex];
            readIndex = (readIndex + 1) % this.data.length;
            out.write(b);
            this.append(b);
        }
    }
}

