/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.version.Version;

public class ProtectedCommand<S extends Diagram>
implements Command<S> {
    private final Command<S> cmd;

    public ProtectedCommand(Command<S> cmd) {
        this.cmd = Objects.requireNonNull(cmd);
    }

    @Override
    public CommandExecutionResult execute(S system, BlocLines lines) {
        try {
            CommandExecutionResult result = this.cmd.execute(system, lines);
            return result;
        }
        catch (Throwable t) {
            Log.error("Error " + t);
            t.printStackTrace();
            String msg = "You should send a mail to plantuml@gmail.com or post to http://plantuml.com/qa with this log (V" + Version.versionString() + ")";
            Log.error(msg);
            msg = msg + " " + t.toString();
            return CommandExecutionResult.error(msg, t);
        }
    }

    @Override
    public CommandControl isValid(BlocLines lines) {
        return this.cmd.isValid(lines);
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }
}

