/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleCache;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.AddStyle;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandCreoleStyle
extends CommandCreoleCache
implements Command {
    private final FontStyle style;
    private final boolean tryExtendedColor;

    @Override
    public String startingChars() {
        return "</*_~-";
    }

    public static Command createCreole(FontStyle style) {
        return new CommandCreoleStyle("^(" + style.getCreoleSyntax() + "(.+?)" + style.getCreoleSyntax() + ")", style, false);
    }

    public static Command createLegacy(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+?)" + style.getDeactivationPattern() + ")", style, style.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+))$", style, style.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String p, FontStyle style, boolean tryExtendedColor) {
        super(p);
        this.style = style;
        this.tryExtendedColor = tryExtendedColor;
    }

    private HColor getExtendedColor(Matcher2 m3) {
        if (this.tryExtendedColor) {
            return this.style.getExtendedColor(m3.group(2));
        }
        return null;
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = new AddStyle(this.style, this.getExtendedColor(m3)).apply(fc1);
        stripe.setActualFontConfiguration(fc2);
        int groupCount = m3.groupCount();
        stripe.analyzeAndAdd(m3.group(groupCount));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }
}

