/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;

public abstract class BodyEnhancedAbstract
extends AbstractTextBlock
implements TextBlock {
    protected final HorizontalAlignment align;
    protected final FontConfiguration titleConfig;
    protected TextBlock area;
    private final Style style;

    BodyEnhancedAbstract(HorizontalAlignment align, FontConfiguration titleConfig, Style style) {
        this.align = align;
        this.titleConfig = titleConfig;
        this.style = style;
    }

    public static boolean isBlockSeparator(CharSequence cs) {
        String s2 = cs.toString();
        if (s2.startsWith("--") && s2.endsWith("--")) {
            return true;
        }
        if (s2.startsWith("==") && s2.endsWith("==")) {
            return true;
        }
        if (s2.startsWith("..") && s2.endsWith("..") && !s2.equals("...")) {
            return true;
        }
        return s2.startsWith("__") && s2.endsWith("__");
    }

    @Override
    public final Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    protected final TextBlock getTitle(String s2, ISkinSimple spriteContainer) {
        if (s2.length() <= 4) {
            return null;
        }
        s2 = StringUtils.trin(s2.substring(2, s2.length() - 2));
        return Display.getWithNewlines(s2).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    protected abstract TextBlock getArea(StringBounder var1);

    protected abstract double getMarginX();

    protected final TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        double marginX = this.getMarginX();
        if (separator == '\u0000') {
            return TextBlockUtils.withMargin(b, marginX, 0.0);
        }
        if (title == null) {
            return new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(b, marginX, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(b, marginX, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    protected final double getDefaultThickness() {
        return this.style.value(PName.LineThickness).asDouble();
    }
}

