/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotag;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;

public class HideOrShow2 {
    private final String what;
    private final boolean show;

    public String toString() {
        return this.what + " (" + this.show + ")";
    }

    private boolean isApplyable(ILeaf leaf) {
        if (this.what.startsWith("$")) {
            return this.isApplyableTag(leaf, this.what.substring(1));
        }
        if (this.what.startsWith("<<") && this.what.endsWith(">>")) {
            return this.isApplyableStereotype(leaf, this.what.substring(2, this.what.length() - 2).trim());
        }
        if (this.what.equalsIgnoreCase("@unlinked")) {
            return this.isApplyableUnlinked(leaf);
        }
        String fullName = leaf.getCodeGetName();
        return this.match(fullName, this.what);
    }

    private boolean isApplyableUnlinked(ILeaf leaf) {
        return leaf.isAloneAndUnlinked();
    }

    private boolean isApplyableStereotype(ILeaf leaf, String pattern) {
        Stereotype stereotype = leaf.getStereotype();
        if (stereotype == null) {
            return false;
        }
        for (String label : stereotype.getMultipleLabels()) {
            if (!this.match(label, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isApplyableTag(ILeaf leaf, String pattern) {
        for (Stereotag tag : leaf.stereotags()) {
            if (!this.match(tag.getName(), pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String s2, String pattern) {
        if (pattern.contains("*")) {
            String reg = "^" + pattern.replace("*", ".*") + "$";
            return s2.matches(reg);
        }
        return s2.equals(pattern);
    }

    public HideOrShow2(String what, boolean show) {
        this.what = what;
        this.show = show;
    }

    public boolean apply(boolean hidden, ILeaf leaf) {
        if (this.isApplyable(leaf)) {
            return !this.show;
        }
        return hidden;
    }
}

