/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Elected;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockWithUrl;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Right;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final ISkinParam skinParam;
    private final Display members;
    private final HorizontalAlignment align;
    private final ILeaf leaf;
    private final Style style;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(this.style.value(PName.LineThickness).asDouble(), TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, ILeaf leaf, Style style) {
        this(members, skinParam, HorizontalAlignment.LEFT, leaf, style);
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, HorizontalAlignment align, ILeaf leaf, Style style) {
        this.style = style;
        this.leaf = leaf;
        this.align = align;
        this.skinParam = skinParam;
        this.members = members;
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (CharSequence cs : this.members) {
            Member m3;
            if (!(cs instanceof Member) || (m3 = (Member)cs).getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new Dimension2DDouble(x += smallIcon, y);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports result = new Ports();
        double y = 0.0;
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            Elected port = this.getElected(this.leaf.getPortShortNames(), this.convert(cs));
            if (port != null) {
                result.add(port.getShortName(), port.getScore(), y, dim.getHeight());
            }
            y += dim.getHeight();
        }
        return result;
    }

    private String convert(CharSequence cs) {
        if (cs instanceof Member) {
            return ((Member)cs).getDisplay(false);
        }
        return cs.toString();
    }

    public Elected getElected(Collection<String> shortNames, String cs) {
        for (String shortName : new HashSet<String>(shortNames)) {
            int score = this.getScore(shortName, cs);
            if (score <= 0) continue;
            return new Elected(shortName, score);
        }
        return null;
    }

    private int getScore(String shortName, String cs) {
        if (cs.matches(".*\\b" + shortName + "\\b.*")) {
            return 100;
        }
        if (cs.contains(shortName)) {
            return 50;
        }
        return 0;
    }

    private TextBlock createTextBlock(CharSequence cs) {
        FontConfiguration config = FontConfiguration.create(this.skinParam, this.style, this.leaf.getColors());
        if (cs instanceof Member) {
            Member m3 = (Member)cs;
            boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
            String s2 = m3.getDisplay(withVisibilityChar);
            if (withVisibilityChar && s2.startsWith("#")) {
                s2 = CharHidder.addTileAtBegin(s2);
            }
            if (m3.isAbstract()) {
                config = config.italic();
            }
            if (m3.isStatic()) {
                config = config.underline();
            }
            TextBlock bloc = Display.getWithNewlines(s2).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.skinParam.wrapWidth());
            bloc = TextBlockUtils.fullInnerPosition(bloc, m3.getDisplay(false));
            return new TextBlockTracer(m3, bloc);
        }
        if (cs instanceof EmbeddedDiagram) {
            return ((EmbeddedDiagram)cs).asDraw(this.skinParam);
        }
        return Display.getWithNewlines(cs.toString()).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.skinParam.wrapWidth());
    }

    private TextBlock getUBlock(VisibilityModifier modifier, Url url) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                    return null;
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        Style style = modifier.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        boolean isField = modifier.isField();
        HColor backColor = isField ? null : style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), borderColor, backColor, url != null);
        return TextBlockWithUrl.withUrl(uBlock, url);
    }

    public boolean contains(String member) {
        for (CharSequence cs : this.members) {
            Member att = (Member)cs;
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        ULayoutGroup group = this.getLayout(stringBounder);
        Dimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                if (cs instanceof EmbeddedDiagram) {
                    group.add(this.getUBlock(null, null));
                } else {
                    Member att = (Member)cs;
                    VisibilityModifier modifier = att.getVisibilityModifier();
                    group.add(this.getUBlock(modifier, att.getUrl()));
                }
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy = this.align == HorizontalAlignment.LEFT ? new PlacementStrategyY1Y2Left(stringBounder) : (this.align == HorizontalAlignment.CENTER ? new PlacementStrategyY1Y2Center(stringBounder) : new PlacementStrategyY1Y2Right(stringBounder));
            group = new ULayoutGroup(placementStrategy);
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        ULayoutGroup group = this.getLayout(ug.getStringBounder());
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        group.drawU(ug, dim.getWidth(), dim.getHeight());
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m3, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m3.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeUrl();
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return this.bloc.getInnerPosition(member, stringBounder, strategy);
        }
    }
}

