/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.security.SFile;

abstract class AbstractGraphviz
implements Graphviz {
    private final File dotExe = this.searchDotExe();
    private final String dotString;
    private final String[] type;

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static String findExecutableOnPath(String name) {
        String path = System.getenv("PATH");
        if (path != null) {
            for (String dirname : path.split(SFile.pathSeparator)) {
                File file = new File(dirname, name);
                if (!file.isFile() || !file.canExecute()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    AbstractGraphviz(ISkinParam skinParam, String dotString, String ... type) {
        this.dotString = dotString;
        this.type = Objects.requireNonNull(type);
    }

    protected boolean findExecutableOnPath() {
        return true;
    }

    protected final File searchDotExe() {
        String getenv = GraphvizUtils.getenvGraphvizDot();
        if (this.findExecutableOnPath() && getenv == null) {
            getenv = AbstractGraphviz.findExecutableOnPath(this.getExeName());
        }
        if (getenv == null) {
            return this.specificDotExe();
        }
        return new File(getenv);
    }

    protected abstract File specificDotExe();

    protected abstract String getExeName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProcessState createFile3(OutputStream os) {
        Objects.requireNonNull(this.dotString);
        if (this.getExeState() != ExeState.OK) {
            throw new IllegalStateException();
        }
        String[] cmd = this.getCommandLine();
        ProcessRunner p = null;
        ProcessState state = null;
        try {
            Log.info("Starting Graphviz process " + Arrays.asList(cmd));
            Log.info("DotString size: " + this.dotString.length());
            p = new ProcessRunner(cmd);
            state = p.run(this.dotString.getBytes(), os);
            Log.info("Ending process ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Log.error("Error: " + e);
            Log.error("The command was " + cmd);
            Log.error("");
            Log.error("Try java -jar plantuml.jar -testdot to figure out the issue");
            Log.error("");
        }
        finally {
            Log.info("Ending Graphviz process");
        }
        if (OptionFlags.getInstance().isCheckDotError() && p != null && p.getError().length() > 0) {
            Log.error("GraphViz error stream : " + p.getError());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot error " + p.getError());
            }
        }
        if (OptionFlags.getInstance().isCheckDotError() && p != null && p.getOut().length() > 0) {
            Log.error("GraphViz out stream : " + p.getOut());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot out " + p.getOut());
            }
        }
        return state;
    }

    @Override
    public final ExeState getExeState() {
        return ExeState.checkFile(this.dotExe);
    }

    @Override
    public final String dotVersion() {
        String[] cmd = this.getCommandLineVersion();
        return this.executeCmd(cmd);
    }

    private String executeCmd(String[] cmd) {
        ProcessRunner p = new ProcessRunner(cmd);
        ProcessState state = p.run(null, null);
        if (state.differs(ProcessState.TERMINATED_OK())) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty(p.getOut())) {
            sb.append(p.getOut());
        }
        if (StringUtils.isNotEmpty(p.getError())) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(p.getError());
        }
        return StringUtils.trin(sb.toString().replace('\n', ' '));
    }

    final String[] getCommandLine() {
        if (OptionFlags.ADD_NICE_FOR_DOT) {
            String[] result = new String[this.type.length + 1 + 3];
            result[0] = "/bin/nice";
            result[1] = "-n";
            result[2] = "10";
            result[3] = this.getDotExe().getAbsolutePath();
            for (int i = 0; i < this.type.length; ++i) {
                result[i + 4] = "-T" + this.type[i];
            }
            return result;
        }
        String[] result = new String[this.type.length + 1];
        result[0] = this.getDotExe().getAbsolutePath();
        for (int i = 0; i < this.type.length; ++i) {
            result[i + 1] = "-T" + this.type[i];
        }
        return result;
    }

    final String[] getCommandLineVersion() {
        return new String[]{this.getDotExe().getAbsolutePath(), "-V"};
    }

    @Override
    public final File getDotExe() {
        return this.dotExe;
    }

    public final String getDotString() {
        return this.dotString;
    }

    public final List<String> getType() {
        return Arrays.asList(this.type);
    }
}

