/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.SvekLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Neighborhood {
    private final ILeaf leaf;
    private final List<Link> sametailLinks;
    private final List<Link> allButSametails;
    private static final double epsilon = 0.001;

    public Neighborhood(ILeaf leaf, List<Link> sametailLinks, List<Link> all) {
        this.leaf = leaf;
        this.sametailLinks = sametailLinks;
        this.allButSametails = new ArrayList<Link>(all);
        this.allButSametails.removeAll(sametailLinks);
    }

    public void drawU(UGraphic ug, double minX, double minY, Bibliotekon bibliotekon, Dimension2D shapeDim) {
        HashSet<Point2D> contactPoints = new HashSet<Point2D>();
        for (Link link : this.sametailLinks) {
            SvekLine line = bibliotekon.getLine(link);
            Point2D contact = line.getStartContactPoint();
            contactPoints.add(contact);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(minX, minY, shapeDim.getWidth(), shapeDim.getHeight());
        Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
        for (Point2D pt : contactPoints) {
            Point2D inter = Neighborhood.intersection(rect, center, pt);
            if (inter == null) {
                assert (false);
                continue;
            }
            double theta = Math.atan2(((Point2D)center).getX() - pt.getX(), -(((Point2D)center).getY() - pt.getY()));
            Point2D middle = this.drawExtends(ug, inter, theta);
            this.drawLine(ug, middle, pt);
        }
        for (Link link : this.allButSametails) {
            Point2D inter;
            SvekLine line = bibliotekon.getLine(link);
            Point2D contact = link.getEntity1() == this.leaf ? line.getStartContactPoint() : line.getEndContactPoint();
            if (contact == null || (inter = Neighborhood.intersection(rect, center, contact)) == null) continue;
            this.drawLine(ug, inter, contact);
        }
    }

    private Point2D drawExtends(UGraphic ug, Point2D contact, double theta) {
        UPolygon poly = new UPolygon();
        poly.addPoint(0.0, 0.0);
        poly.addPoint(7.0, 20.0);
        poly.addPoint(-7.0, 20.0);
        poly.rotate(theta);
        UTranslate translate = new UTranslate(contact);
        ug.apply(translate).draw(poly);
        Point2D p1 = translate.getTranslated(poly.getPoints().get(1));
        Point2D p2 = translate.getTranslated(poly.getPoints().get(2));
        return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    static Point2D intersection(Rectangle2D rect, Point2D pt1, Point2D pt2) {
        Point2D p = Neighborhood.intersection(new Point2D.Double(rect.getMinX(), rect.getMinY()), new Point2D.Double(rect.getMaxX(), rect.getMinY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new Point2D.Double(rect.getMinX(), rect.getMaxY()), new Point2D.Double(rect.getMaxX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new Point2D.Double(rect.getMinX(), rect.getMinY()), new Point2D.Double(rect.getMinX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        p = Neighborhood.intersection(new Point2D.Double(rect.getMaxX(), rect.getMinY()), new Point2D.Double(rect.getMaxX(), rect.getMaxY()), pt1, pt2);
        if (p != null) {
            return p;
        }
        return null;
    }

    private static Point2D intersection(Point2D pt1, Point2D pt2, Point2D pt3, Point2D pt4) {
        return Neighborhood.intersection(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY());
    }

    private static Point2D intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return null;
        }
        double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
        double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
        Point2D.Double p = new Point2D.Double(xi, yi);
        if (xi + 0.001 < Math.min(x1, x2) || xi - 0.001 > Math.max(x1, x2)) {
            return null;
        }
        if (xi + 0.001 < Math.min(x3, x4) || xi - 0.001 > Math.max(x3, x4)) {
            return null;
        }
        if (yi + 0.001 < Math.min(y1, y2) || yi - 0.001 > Math.max(y1, y2)) {
            return null;
        }
        if (yi + 0.001 < Math.min(y3, y4) || yi - 0.001 > Math.max(y3, y4)) {
            return null;
        }
        return p;
    }

    private void drawLine(UGraphic ug, Point2D pt1, Point2D pt2) {
        this.drawLine(ug, pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        ULine line = new ULine(x2 - x1, y2 - y1);
        ug.apply(new UTranslate(x1, y1)).draw(line);
    }
}

