/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateDomain
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String DISPLAY_WITH_GENERIC = "[%g](.+?)(?:\\<(" + GenericRegexProducer.PATTERN + ")\\>)?[%g]";
    public static final String CODE = "[^%s{}%g<>]+";

    public CommandCreateDomain() {
        super(CommandCreateDomain.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateDomain.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(requirement|domain)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY", DISPLAY_WITH_GENERIC), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([a-zA-Z0-9]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("GROUP", "(\\{)?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String s2;
        IEntity entity;
        Ident code;
        String type = arg.get("TYPE", 0);
        String display = arg.getLazzy("DISPLAY", 0);
        String codeString = arg.getLazzy("CODE", 0);
        if (codeString == null) {
            codeString = display;
        }
        String stereotype = arg.get("STEREO", 0);
        Ident ident = diagram.buildLeafIdent(codeString);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(codeString);
        if (diagram.V1972() && diagram.leafExistSmart(ident)) {
            return CommandExecutionResult.error("Object already exists : " + codeString);
        }
        if (!diagram.V1972() && diagram.leafExist(code)) {
            return CommandExecutionResult.error("Object already exists : " + codeString);
        }
        Display d = Display.getWithNewlines(display);
        String urlString = arg.get("URL", 0);
        String group = arg.get("GROUP", 0);
        if (group != null) {
            IGroup currentGroup = diagram.getCurrentGroup();
            diagram.gotoGroup(ident, code, d, type.equalsIgnoreCase("domain") ? GroupType.DOMAIN : GroupType.REQUIREMENT, currentGroup, NamespaceStrategy.SINGLE);
            entity = diagram.getCurrentGroup();
        } else {
            entity = diagram.createLeaf(ident, code, d, type.equalsIgnoreCase("domain") ? LeafType.DOMAIN : LeafType.REQUIREMENT, null);
        }
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = arg.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s2));
        if (type.equalsIgnoreCase("domain")) {
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Machine>>")) {
                type = "machine";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Causal>>")) {
                type = "causal";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Designed>>")) {
                type = "designed";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Lexical>>")) {
                type = "lexical";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Biddable>>")) {
                type = "biddable";
            }
        }
        USymbol usymbol = USymbols.fromString(type, diagram.getSkinParam());
        entity.setUSymbol(usymbol);
        return CommandExecutionResult.ok();
    }
}

