/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    public DescriptionDiagram(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        super(style, source, UmlDiagramType.DESCRIPTION, skinParam);
    }

    @Override
    public Ident cleanIdent(Ident ident) {
        String codeString = ident.getName();
        if (codeString.startsWith("[") && codeString.endsWith("]")) {
            return ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        }
        if (codeString.startsWith(":") && codeString.endsWith(":")) {
            return ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        }
        if (codeString.startsWith("()")) {
            codeString = StringUtils.trin(codeString.substring(2));
            codeString = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeString);
            return ident.parent().add(Ident.empty().add(codeString, null));
        }
        return ident;
    }

    @Override
    public ILeaf getOrCreateLeaf(Ident ident, Code code, LeafType type, USymbol symbol) {
        Objects.requireNonNull(ident);
        if (type == null) {
            String codeString = code.getName();
            if (codeString.startsWith("[") && codeString.endsWith("]")) {
                USymbol sym = this.getSkinParam().componentStyle().toUSymbol();
                Ident idNewLong = ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
                return this.getOrCreateLeafDefault(idNewLong, idNewLong.toCode(this), LeafType.DESCRIPTION, sym);
            }
            if (codeString.startsWith(":") && codeString.endsWith(":")) {
                Ident idNewLong = ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
                return this.getOrCreateLeafDefault(idNewLong, idNewLong.toCode(this), LeafType.DESCRIPTION, this.getSkinParam().actorStyle().toUSymbol());
            }
            if (codeString.startsWith("()")) {
                codeString = StringUtils.trin(codeString.substring(2));
                codeString = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeString);
                Ident idNewLong = this.buildLeafIdent(codeString);
                Ident code99 = this.V1972() ? idNewLong : this.buildCode(codeString);
                return this.getOrCreateLeafDefault(idNewLong, code99, LeafType.DESCRIPTION, USymbols.INTERFACE);
            }
            String tmp4 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(code.getName(), "\"([:");
            Ident idNewLong = ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            code = this.V1972() ? idNewLong : this.buildCode(tmp4);
            return this.getOrCreateLeafDefault(idNewLong, code, LeafType.STILL_UNKNOWN, symbol);
        }
        return this.getOrCreateLeafDefault(ident, code, type, symbol);
    }

    private boolean isUsecase() {
        for (ILeaf leaf : this.getLeafsvalues()) {
            LeafType type = leaf.getLeafType();
            USymbol usymbol = leaf.getUSymbol();
            if (type != LeafType.USECASE && usymbol != this.getSkinParam().actorStyle().toUSymbol()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        LeafType defaultType = LeafType.DESCRIPTION;
        USymbol defaultSymbol = this.isUsecase() ? this.getSkinParam().actorStyle().toUSymbol() : USymbols.INTERFACE;
        for (ILeaf leaf : this.getLeafsvalues()) {
            if (leaf.getLeafType() != LeafType.STILL_UNKNOWN) continue;
            leaf.muteToType(defaultType, defaultSymbol);
        }
    }

    @Override
    public String checkFinalError() {
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

