/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.eggs;

import java.math.BigInteger;
import znaishaded.net.sourceforge.plantuml.StringUtils;

public class EggUtils {
    public static String fromByteArrays(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] toByteArrays(String s2) {
        byte[] result = new byte[s2.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)Integer.parseInt(s2.substring(i * 2, i * 2 + 2), 16);
        }
        return result;
    }

    public static BigInteger fromSecretSentence(String s2) {
        BigInteger result = BigInteger.ZERO;
        BigInteger twentySix = BigInteger.valueOf(26L);
        s2 = s2.replace('\u00e9', 'e');
        s2 = s2.replace('\u00ea', 'e');
        for (char c : s2.toCharArray()) {
            int num = EggUtils.convertChar(c);
            if (num == -1) continue;
            result = result.multiply(twentySix);
            result = result.add(BigInteger.valueOf(num));
        }
        return result;
    }

    private static int convertChar(char c) {
        if ((c = StringUtils.goLowerCase(c)) >= 'a' && c <= 'z') {
            return c - 97;
        }
        return -1;
    }

    public static byte[] xor(byte[] data, byte[] key) {
        byte[] result = new byte[data.length];
        int pos = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(data[i] ^ key[pos++]);
            if (pos != key.length) continue;
            pos = 0;
        }
        return result;
    }
}

