/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.gitlog;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.gitlog.GNode;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class MagicBox {
    private final ISkinParam skinParam;
    private final GNode node;
    private final HColor fontColor;

    public MagicBox(ISkinParam skinParam, GNode node) {
        this.skinParam = skinParam;
        this.node = node;
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.gitDiagram).getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.fontColor = style.value(PName.FontColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
    }

    private TextBlock getSmallBlock() {
        FontConfiguration fc = FontConfiguration.create(UFont.monospaced(15).bold(), this.fontColor, this.fontColor, false);
        return this.node.getDisplay().create(fc, HorizontalAlignment.CENTER, this.skinParam);
    }

    private TextBlock getCommentBlock() {
        if (this.node.getComment() != null && this.node.isTop()) {
            FontConfiguration tag = FontConfiguration.create(UFont.sansSerif(13), this.fontColor, this.fontColor, false);
            return Display.create(this.node.getComment()).create(tag, HorizontalAlignment.CENTER, this.skinParam);
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    public Dimension2D getBigDim(StringBounder stringBounder) {
        Dimension2D dimComment = this.getCommentBlock().calculateDimension(stringBounder);
        Dimension2D dimSmall = this.getSmallBlock().calculateDimension(stringBounder);
        Dimension2D mergeTB = Dimension2DDouble.mergeTB(dimComment, dimSmall);
        return Dimension2DDouble.delta(mergeTB, 8.0, 2.0);
    }

    public void drawBorder(UGraphic ug, Dimension2D sizeInDot) {
        TextBlock comment = this.getCommentBlock();
        TextBlock small = this.getSmallBlock();
        double moveY = comment.calculateDimension(ug.getStringBounder()).getHeight();
        URectangle rect = new URectangle(sizeInDot.getWidth(), sizeInDot.getHeight() - moveY).rounded(8.0);
        ug.apply(new UStroke(1.5)).apply(UTranslate.dy(moveY)).draw(rect);
        comment.drawU(ug);
        double deltaWidth = rect.getWidth() - small.calculateDimension(ug.getStringBounder()).getWidth();
        double deltaHeight = rect.getHeight() - small.calculateDimension(ug.getStringBounder()).getHeight();
        small.drawU(ug.apply(new UTranslate(deltaWidth / 2.0, moveY + deltaHeight / 2.0)));
    }
}

