/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.text.RichText;
import znaishaded.net.sourceforge.plantuml.text.StyledString;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;

public abstract class StringBounderRaw
implements StringBounder {
    @Override
    public final Dimension2D calculateDimension(UFont font, String text) {
        if (RichText.isRich(text)) {
            double width = 0.0;
            double height = 0.0;
            for (StyledString s2 : StyledString.build(text)) {
                UFont newFont = s2.getStyle().mutateFont(font);
                Dimension2D rect = this.calculateDimensionInternal(newFont, s2.getText());
                width += rect.getWidth();
                height = Math.max(height, rect.getHeight());
            }
            return new Dimension2DDouble(width, height);
        }
        return this.calculateDimensionInternal(font, text);
    }

    protected abstract Dimension2D calculateDimensionInternal(UFont var1, String var2);

    @Override
    public double getDescent(UFont font, String text) {
        FontRenderContext frc = FileFormat.gg.getFontRenderContext();
        LineMetrics lineMetrics = font.getUnderlayingFont().getLineMetrics(text, frc);
        double descent = lineMetrics.getDescent();
        return descent;
    }
}

