/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.picoweb;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import znaishaded.net.sourceforge.plantuml.code.TranscoderUtil;
import znaishaded.net.sourceforge.plantuml.json.Json;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.picoweb.PicoWebServer;

public class PicoWebServerTest {
    private static int port;

    public static void main(String[] args) throws Exception {
        PicoWebServerTest.startServer();
        PicoWebServerTest.test_basic_http();
        PicoWebServerTest.test_GET_png();
        PicoWebServerTest.test_GET_svg();
        PicoWebServerTest.test_POST_render();
        PicoWebServerTest.test_unknown_path();
    }

    private static void test_basic_http() throws Exception {
        assert (PicoWebServerTest.httpRaw("").equals("HTTP/1.1 400 Bad Request\nContent-type: text/plain\nContent-length: 16\n\nBad request line"));
        assert (PicoWebServerTest.httpRaw("GET").equals("HTTP/1.1 400 Bad Request\nContent-type: text/plain\nContent-length: 16\n\nBad request line"));
        assert (PicoWebServerTest.httpRaw("GET /foo HTTP/1.1\nContent-Length: bar\n").equals("HTTP/1.1 400 Bad Request\nContent-type: text/plain\nContent-length: 22\n\nInvalid content length"));
        assert (PicoWebServerTest.httpRaw("GET /foo HTTP/1.1\nContent-Length: -1\n").equals("HTTP/1.1 400 Bad Request\nContent-type: text/plain\nContent-length: 23\n\nNegative content length"));
        assert (PicoWebServerTest.httpRaw("GET /foo HTTP/1.1\nContent-Length: 3\n\n12").equals("HTTP/1.1 400 Bad Request\nContent-type: text/plain\nContent-length: 14\n\nBody too short"));
    }

    private static void test_GET_png() throws Exception {
        HttpURLConnection response = PicoWebServerTest.httpGet("/png/" + TranscoderUtil.getDefaultTranscoder().encode("A -> B"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/png"));
        assert (PicoWebServerTest.readStreamAsImage(response.getInputStream()) != null);
        response = PicoWebServerTest.httpGet("/plantuml/png/" + TranscoderUtil.getDefaultTranscoder().encode("A -> B"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/png"));
        assert (PicoWebServerTest.readStreamAsImage(response.getInputStream()) != null);
        response = PicoWebServerTest.httpGet("/png/" + TranscoderUtil.getDefaultTranscoder().encode("foo"));
        assert (response.getResponseCode() == 400);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error").equals("Syntax Error?"));
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line").equals("2"));
        assert (response.getContentType().equals("image/png"));
        assert (PicoWebServerTest.readStreamAsImage(response.getErrorStream()) != null);
    }

    private static void test_GET_svg() throws Exception {
        HttpURLConnection response = PicoWebServerTest.httpGet("/svg/" + TranscoderUtil.getDefaultTranscoder().encode("A -> B"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/svg+xml"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).startsWith("<?xml "));
        response = PicoWebServerTest.httpGet("/plantuml/svg/" + TranscoderUtil.getDefaultTranscoder().encode("A -> B"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/svg+xml"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).startsWith("<?xml "));
        response = PicoWebServerTest.httpGet("/svg/" + TranscoderUtil.getDefaultTranscoder().encode("foo"));
        assert (response.getResponseCode() == 400);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error").equals("Syntax Error?"));
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line").equals("2"));
        assert (response.getContentType().equals("image/svg+xml"));
        assert (PicoWebServerTest.readStreamAsString(response.getErrorStream()).startsWith("<?xml "));
    }

    private static void test_POST_render() throws Exception {
        HttpURLConnection response = PicoWebServerTest.httpPostJson("/render", PicoWebServerTest.renderRequestJson("A -> B", new String[0]));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/png"));
        assert (PicoWebServerTest.readStreamAsImage(response.getInputStream()) != null);
        response = PicoWebServerTest.httpPostJson("/render", PicoWebServerTest.renderRequestJson("A -> B", "-tsvg"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("image/svg+xml"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).startsWith("<?xml "));
        response = PicoWebServerTest.httpPostJson("/render", PicoWebServerTest.renderRequestJson("A -> B", "-ttxt"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("text/plain"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).equals("     ,-.          ,-.\n     |A|          |B|\n     `+'          `+'\n      |            | \n      |----------->| \n     ,+.          ,+.\n     |A|          |B|\n     `-'          `-'\n"));
        response = PicoWebServerTest.httpPostJson("/render", PicoWebServerTest.renderRequestJson("foo", "-ttxt"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error").equals("Syntax Error?"));
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line").equals("2"));
        assert (response.getContentType().equals("text/plain"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).equals("[From string (line 2) ]\n                       \n@startuml              \nfoo                    \n^^^^^                  \n Syntax Error?         \n"));
        response = PicoWebServerTest.httpPostJson("/render", PicoWebServerTest.renderRequestJson("@startuml", "-ttxt"));
        assert (response.getResponseCode() == 200);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error").equals("No @startuml/@enduml found"));
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line").equals("0"));
        assert (response.getContentType().equals("text/plain"));
        assert (PicoWebServerTest.readStreamAsString(response.getInputStream()).equals("                               \n                               \n     No @startuml/@enduml found\n"));
        response = PicoWebServerTest.httpPostJson("/render", "");
        assert (response.getResponseCode() == 400);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("text/plain"));
        assert (PicoWebServerTest.readStreamAsString(response.getErrorStream()).equals("No request body"));
        response = PicoWebServerTest.httpPostJson("/render", "123abc");
        assert (response.getResponseCode() == 400);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error") == null);
        assert (response.getHeaderField("X-PlantUML-Diagram-Error-Line") == null);
        assert (response.getContentType().equals("text/plain"));
        assert (PicoWebServerTest.readStreamAsString(response.getErrorStream()).contains("Error parsing request json: Unexpected character at 1:4\n"));
    }

    private static void test_unknown_path() throws Exception {
        HttpURLConnection response = PicoWebServerTest.httpGet("/foo");
        assert (response.getResponseCode() == 302);
        assert (response.getHeaderField("Location").equals("/plantuml/png/oqbDJyrBuGh8ISmh2VNrKGZ8JCuFJqqAJYqgIotY0aefG5G00000"));
    }

    private static HttpURLConnection httpGet(String path) throws Exception {
        return PicoWebServerTest.urlConnection(path);
    }

    private static HttpURLConnection httpPost(String path, String contentType, byte[] content) throws Exception {
        HttpURLConnection conn = PicoWebServerTest.urlConnection(path);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Content-Length", Integer.toString(content.length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(content);
        return conn;
    }

    private static HttpURLConnection httpPostJson(String path, String json) throws Exception {
        return PicoWebServerTest.httpPost(path, "application/json; utf-8", json.getBytes(StandardCharsets.UTF_8));
    }

    private static String httpRaw(String request) throws Exception {
        try (Socket socket = PicoWebServerTest.socketConnection();){
            socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
            socket.shutdownOutput();
            String string = PicoWebServerTest.readStreamAsString(socket.getInputStream()).replaceAll("\r\n", "\n");
            return string;
        }
    }

    private static BufferedImage readStreamAsImage(InputStream in) throws Exception {
        return ImageIO.read(new MemoryCacheImageInputStream(in));
    }

    private static String readStreamAsString(InputStream in) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    private static String renderRequestJson(String source, String ... options) {
        JsonObject object = Json.object();
        object.add("source", source);
        if (options.length != 0) {
            object.add("options", Json.array(options));
        }
        return object.toString();
    }

    private static void startServer() throws Exception {
        final ServerSocket serverSocket = new ServerSocket(0);
        port = serverSocket.getLocalPort();
        Thread serverLoopThread = new Thread("PicoWebServerLoop"){

            @Override
            public void run() {
                try {
                    PicoWebServer.serverLoop(serverSocket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        serverLoopThread.setDaemon(true);
        serverLoopThread.start();
    }

    private static Socket socketConnection() throws IOException {
        return new Socket("localhost", port);
    }

    private static HttpURLConnection urlConnection(String path) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL("http://localhost:" + port + path).openConnection();
        conn.setInstanceFollowRedirects(false);
        return conn;
    }
}

