/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Point2D;
import java.util.Locale;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.posimo.Cluster;
import znaishaded.net.sourceforge.plantuml.posimo.Clusterable;

public class Block
implements Clusterable {
    private final int uid;
    private final double width;
    private final double height;
    private double x;
    private double y;
    private final Cluster parent;

    public Block(int uid, double width, double height, Cluster parent) {
        this.uid = uid;
        this.width = width;
        this.height = height;
        this.parent = parent;
    }

    public String toString() {
        return "BLOCK " + this.uid;
    }

    public String toStringPosition() {
        return String.format(Locale.US, "x=%9.2f y=%9.2f w=%9.2f h=%9.2f", this.x, this.y, this.width, this.height);
    }

    public int getUid() {
        return this.uid;
    }

    @Override
    public Cluster getParent() {
        return this.parent;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public void setCenterX(double center) {
        this.x = center - this.width / 2.0;
    }

    public void setCenterY(double center) {
        this.y = center - this.height / 2.0;
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        throw new UnsupportedOperationException();
    }
}

