/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import java.util.Locale;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.MonthYear;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleDaily;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TimeHeaderDaily
extends TimeHeaderCalendar {
    private final Map<Day, String> nameDays;

    @Override
    public double getTimeHeaderHeight() {
        return this.Y_POS_ROW28() + 13.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 38.0;
    }

    public TimeHeaderDaily(Locale locale, Style timelineStyle, Style closedStyle, double scale, Day calendar, Day min2, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, Map<Day, String> nameDays, Day printStart, Day printEnd, HColorSet colorSet, ThemeStyle themeStyle) {
        super(locale, timelineStyle, closedStyle, calendar, min2, max, defaultPlan, colorDays, colorDaysOfWeek, new TimeScaleDaily(scale, calendar, printStart), colorSet, themeStyle);
        this.nameDays = nameDays;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawTextsDayOfWeek(ug.apply(UTranslate.dy(this.Y_POS_ROW16())));
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(this.Y_POS_ROW28())));
        this.drawMonths(ug);
        this.printSmallVbars(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, this.getFullHeaderHeight());
        this.drawHline(ug, totalHeightWithoutFooter);
    }

    private void printSmallVbars(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), this.getFullHeaderHeight(), totalHeightWithoutFooter);
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), this.getFullHeaderHeight(), totalHeightWithoutFooter);
    }

    private void drawVBars(UGraphic ug, double totalHeightWithoutFooter) {
        MonthYear last = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double startingY = this.getFullHeaderHeight();
            double len = totalHeightWithoutFooter;
            if (!wink.monthYear().equals(last)) {
                startingY = 0.0;
                last = wink.monthYear();
                len += 37.0;
            }
            this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), startingY, len);
            wink = wink.increment();
        }
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(12.0)));
        this.drawTextsDayOfWeek(ug);
        this.drawMonths(ug.apply(UTranslate.dy(24.0)));
    }

    private void drawTextsDayOfWeek(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor textColor = this.getTextBackColor(wink);
            this.printCentered(ug, this.getTextBlock(wink.getDayOfWeek().shortName(this.locale), 10, false, textColor), x1, x2);
            wink = wink.increment();
        }
    }

    private void drawTextDayOfMonth(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor textColor = this.getTextBackColor(wink);
            this.printCentered(ug, this.getTextBlock("" + wink.getDayOfMonth(), 10, false, textColor), x1, x2);
            wink = wink.increment();
        }
    }

    private HColor getTextBackColor(Day wink) {
        if (this.defaultPlan.getLoadAt(wink) <= 0) {
            return this.closedFontColor();
        }
        return this.openFontColor();
    }

    private void drawMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock tiny = this.getTextBlock(monthYear.shortName(this.locale), 12, true, this.openFontColor());
        TextBlock small = this.getTextBlock(monthYear.longName(this.locale), 12, true, this.openFontColor());
        TextBlock big = this.getTextBlock(monthYear.longNameYYYY(this.locale), 12, true, this.openFontColor());
        this.printCentered(ug, false, start, end, tiny, small, big);
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.min;
            while (wink.compareTo(this.max.increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(name, 12, false, this.openFontColor());
                    double h2 = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight();
                    double y2 = this.getFullHeaderHeight();
                    label.drawU(ug.apply(new UTranslate(x1, this.Y_POS_ROW28() + 11.0)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            return 16.0;
        }
        return 0.0;
    }
}

