/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.lang.Something;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.Month;

public class ComplementDate
implements Something {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexOr(this.toRegexA(suffix), this.toRegexB(suffix), this.toRegexC(suffix), this.toRegexD(suffix), this.toRegexE(suffix));
    }

    private IRegex toRegexA(String suffix) {
        return new RegexConcat(new RegexLeaf("ADAY" + suffix, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AMONTH" + suffix, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AYEAR" + suffix, "([\\d]{4})"));
    }

    private IRegex toRegexB(String suffix) {
        return new RegexConcat(new RegexLeaf("BYEAR" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY" + suffix, "([\\d]{1,2})"));
    }

    private IRegex toRegexC(String suffix) {
        return new RegexConcat(new RegexLeaf("CMONTH" + suffix, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CDAY" + suffix, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CYEAR" + suffix, "([\\d]{4})"));
    }

    private IRegex toRegexD(String suffix) {
        return new RegexConcat(new RegexLeaf("DCOUNT" + suffix, "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("days?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("after"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("start"));
    }

    private IRegex toRegexE(String suffix) {
        return new RegexConcat(new RegexLeaf("[dD]\\+"), new RegexLeaf("ECOUNT" + suffix, "([\\d]+)"));
    }

    public Failable<Day> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        if (arg.get("ADAY" + suffix, 0) != null) {
            return Failable.ok(this.resultA(arg, suffix));
        }
        if (arg.get("BDAY" + suffix, 0) != null) {
            return Failable.ok(this.resultB(arg, suffix));
        }
        if (arg.get("CDAY" + suffix, 0) != null) {
            return Failable.ok(this.resultC(arg, suffix));
        }
        if (arg.get("DCOUNT" + suffix, 0) != null) {
            return Failable.ok(this.resultD(system, arg, suffix));
        }
        if (arg.get("ECOUNT" + suffix, 0) != null) {
            return Failable.ok(this.resultE(system, arg, suffix));
        }
        throw new IllegalStateException();
    }

    private Day resultA(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("ADAY" + suffix, 0));
        String month = arg.get("AMONTH" + suffix, 0);
        int year = Integer.parseInt(arg.get("AYEAR" + suffix, 0));
        return Day.create(year, month, day);
    }

    private Day resultB(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("BDAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("BMONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("BYEAR" + suffix, 0));
        return Day.create(year, month, day);
    }

    private Day resultC(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("CDAY" + suffix, 0));
        String month = arg.get("CMONTH" + suffix, 0);
        int year = Integer.parseInt(arg.get("CYEAR" + suffix, 0));
        return Day.create(year, month, day);
    }

    private Day resultD(GanttDiagram system, RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DCOUNT" + suffix, 0));
        return system.getStartingDate().addDays(day);
    }

    private Day resultE(GanttDiagram system, RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("ECOUNT" + suffix, 0));
        return system.getStartingDate().addDays(day);
    }
}

