/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.security.authentication;

import java.util.Arrays;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityCredentialsContainer;

public class SecurityAuthentication
implements SecurityCredentialsContainer {
    private final String type;
    private final String shape;
    private final String grantType;
    private final Map<String, Object> tokens;

    public SecurityAuthentication(String type, Map<String, Object> tokens) {
        this(type, null, null, tokens);
    }

    public SecurityAuthentication(String type, String shape, String grantType, Map<String, Object> tokens) {
        this.type = type;
        this.shape = shape;
        this.grantType = grantType;
        this.tokens = tokens;
    }

    public String getType() {
        return this.type;
    }

    public String getShape() {
        return this.shape;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public boolean isPublic() {
        return "public".equalsIgnoreCase(this.type) && (this.tokens == null || this.tokens.isEmpty());
    }

    public Map<String, Object> getTokens() {
        return this.tokens;
    }

    @Override
    public void eraseCredentials() {
        if (this.tokens != null && !this.tokens.isEmpty()) {
            for (Object tokenVal : this.tokens.values()) {
                if (!(tokenVal instanceof char[])) continue;
                Arrays.fill((char[])tokenVal, '*');
            }
            this.tokens.clear();
        }
    }
}

