/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public final class GroupingLeaf
extends Grouping
implements EventWithDeactivate {
    private final GroupingStart start;
    private final HColor backColorGeneral;
    private double posYendLevel;
    private List<Note> noteOnMessages = new ArrayList<Note>();

    public GroupingLeaf(String title, String comment, GroupingType type, HColor backColorGeneral, HColor backColorElement, GroupingStart start, StyleBuilder styleBuilder) {
        super(title, comment, type, backColorElement, styleBuilder);
        this.backColorGeneral = backColorGeneral;
        this.start = Objects.requireNonNull(start);
        start.addChildren(this);
    }

    public Grouping getJustAfter() {
        int idx = this.start.getChildren().indexOf(this);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        if (idx + 1 >= this.start.getChildren().size()) {
            return null;
        }
        return this.start.getChildren().get(idx + 1);
    }

    public GroupingStart getGroupingStart() {
        return this.start;
    }

    @Override
    public int getLevel() {
        return this.start.getLevel();
    }

    @Override
    public final HColor getBackColorGeneral() {
        if (this.backColorGeneral == null) {
            return this.start.getBackColorGeneral();
        }
        return this.backColorGeneral;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return false;
    }

    @Override
    public Url getUrl() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        return false;
    }

    @Override
    public boolean isParallel() {
        return this.start.isParallel();
    }

    @Override
    public void setPosYendLevel(double posYendLevel) {
        this.posYendLevel = posYendLevel;
    }

    @Override
    public double getPosYendLevel() {
        return this.posYendLevel;
    }

    @Override
    public boolean addLifeEvent(LifeEvent lifeEvent) {
        return true;
    }

    public final void setNote(Note note) {
        if (note.getPosition() != NotePosition.LEFT && note.getPosition() != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.noteOnMessages.add(note);
    }

    public final List<Note> getNoteOnMessages() {
        return this.noteOnMessages;
    }
}

