/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.InGroupable;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageExoType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementElse;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.MessageExoArrow;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;

public class InGroupableList
implements InGroupable {
    private static final int MARGIN5 = 5;
    public static final int MARGIN10 = 10;
    private final Grouping grouping;
    private final Set<InGroupable> inGroupables = new HashSet<InGroupable>();
    private double minWidth;
    private final ParticipantBox veryfirst;
    private InGroupable cacheMin = null;
    private InGroupable cacheMax = null;
    private double hack2;

    public List<InGroupableList> getInnerList() {
        ArrayList<InGroupableList> result = new ArrayList<InGroupableList>();
        for (InGroupable i : this.inGroupables) {
            if (!(i instanceof InGroupableList)) continue;
            result.add((InGroupableList)i);
        }
        return result;
    }

    public InGroupableList(ParticipantBox veryfirst, Grouping grouping, double startingY) {
        this.grouping = grouping;
        this.veryfirst = veryfirst;
    }

    public void addInGroupable(InGroupable in) {
        this.inGroupables.add(in);
        this.cacheMin = null;
        this.cacheMax = null;
    }

    public boolean isEmpty() {
        return this.inGroupables.isEmpty();
    }

    public String toString() {
        return "GS " + this.grouping + " " + this.inGroupables.toString();
    }

    @Override
    public String toString(StringBounder stringBounder) {
        StringBuilder sb = new StringBuilder("GS " + this.grouping + " ");
        for (InGroupable in : this.inGroupables) {
            sb.append(in.toString(stringBounder));
            sb.append(' ');
        }
        return sb.toString();
    }

    private InGroupable getMinSlow(StringBounder stringBounder) {
        InGroupable result = null;
        for (InGroupable in : this.inGroupables) {
            if (in instanceof GroupingGraphicalElementElse || result != null && !(in.getMinX(stringBounder) < result.getMinX(stringBounder))) continue;
            result = in;
        }
        return result;
    }

    private InGroupable getMaxSlow(StringBounder stringBounder) {
        InGroupable result = null;
        for (InGroupable in : this.inGroupables) {
            if (result != null && !(in.getMaxX(stringBounder) > result.getMaxX(stringBounder))) continue;
            result = in;
        }
        return result;
    }

    private InGroupable getMin(StringBounder stringBounder) {
        if (this.cacheMin == null) {
            this.cacheMin = this.getMinSlow(stringBounder);
        }
        return this.cacheMin;
    }

    private InGroupable getMax(StringBounder stringBounder) {
        if (this.cacheMax == null) {
            this.cacheMax = this.getMaxSlow(stringBounder);
        }
        assert (this.cacheMax == this.getMaxSlow(stringBounder));
        return this.cacheMax;
    }

    public void setMinWidth(double minWidth) {
        this.minWidth = minWidth;
    }

    public ParticipantBox getFirstParticipantBox() {
        ParticipantBox first = null;
        for (InGroupable in : this.inGroupables) {
            if (!(in instanceof LivingParticipantBox)) continue;
            ParticipantBox participantBox = ((LivingParticipantBox)in).getParticipantBox();
            if (first != null && !(participantBox.getStartingX() < first.getStartingX())) continue;
            first = participantBox;
        }
        return first;
    }

    public ParticipantBox getLastParticipantBox() {
        ParticipantBox last = null;
        for (InGroupable in : this.inGroupables) {
            if (!(in instanceof LivingParticipantBox)) continue;
            ParticipantBox participantBox = ((LivingParticipantBox)in).getParticipantBox();
            if (last != null && !(participantBox.getStartingX() > last.getStartingX())) continue;
            last = participantBox;
        }
        return last;
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        InGroupable min2 = this.getMin(stringBounder);
        if (min2 == null) {
            return 15.0 + (this.veryfirst == null ? 0.0 : this.veryfirst.getStartingX());
        }
        double m3 = min2.getMinX(stringBounder);
        m3 = min2 instanceof MessageExoArrow && (((MessageExoArrow)min2).getType() == MessageExoType.FROM_LEFT || ((MessageExoArrow)min2).getType() == MessageExoType.TO_LEFT) ? (m3 += 3.0) : (min2 instanceof InGroupableList ? (m3 -= 10.0) : (m3 -= 5.0));
        return m3;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        double min2 = this.getMinX(stringBounder);
        double max = this.getMaxXInternal(stringBounder);
        assert (max - min2 >= 0.0);
        if (max - min2 < this.minWidth) {
            return min2 + this.minWidth + this.hack2;
        }
        return max + this.hack2;
    }

    private final double getMaxXInternal(StringBounder stringBounder) {
        InGroupable max = this.getMax(stringBounder);
        if (max == null) {
            return 15.0 + this.minWidth;
        }
        double m3 = max.getMaxX(stringBounder);
        m3 = max instanceof MessageExoArrow && (((MessageExoArrow)max).getType() == MessageExoType.FROM_RIGHT || ((MessageExoArrow)max).getType() == MessageExoType.TO_RIGHT) ? (m3 -= 3.0) : (max instanceof InGroupableList ? (m3 += 10.0) : (m3 += 5.0));
        return m3;
    }

    public void changeHack2(double hack2) {
        this.hack2 += hack2;
    }

    public double getHack2() {
        return this.hack2;
    }
}

