/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommonTile;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class LinkAnchor {
    private final String anchor1;
    private final String anchor2;
    private final String message;

    public LinkAnchor(String anchor1, String anchor2, String message) {
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
        this.message = message;
    }

    public String toString() {
        return this.anchor1 + "<->" + this.anchor2 + " " + this.message;
    }

    public final String getAnchor1() {
        return this.anchor1;
    }

    public final String getAnchor2() {
        return this.anchor2;
    }

    public final String getMessage() {
        return this.message;
    }

    public void drawAnchor(UGraphic ug, CommonTile tile1, CommonTile tile2, ISkinParam skinParam) {
        double y1 = tile1.getY() + tile1.getContactPointRelative();
        double y2 = tile2.getY() + tile2.getContactPointRelative();
        double xx1 = tile1.getMiddleX();
        double xx2 = tile2.getMiddleX();
        double x = (xx1 + xx2) / 2.0;
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.arrow);
        Style style = signature.getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor color = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        FontConfiguration fontConfiguration = FontConfiguration.create(skinParam, style);
        Rainbow rainbow = Rainbow.fromColor(color, null);
        Display display = Display.getWithNewlines(this.message);
        TextBlock title = display.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
        Snake snake = Snake.create(skinParam, Arrows.asToUp(), rainbow, Arrows.asToDown()).withLabel(title, HorizontalAlignment.CENTER);
        snake.addPoint(x, ymin + 2.0);
        snake.addPoint(x, ymax - 2.0);
        snake.drawInternal(ug);
    }
}

