/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style;

import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.style.NoStyleAvailableException;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleLoader;

public class CommandStyleMultilinesCSS
extends CommandMultilines2<TitledDiagram> {
    public CommandStyleMultilinesCSS() {
        super(CommandStyleMultilinesCSS.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\</style\\>[%s]*$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleMultilinesCSS.class.getName(), RegexLeaf.start(), new RegexLeaf("\\<style\\>"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram diagram, BlocLines lines) {
        try {
            StyleBuilder styleBuilder = diagram.getSkinParam().getCurrentStyleBuilder();
            for (Style modifiedStyle : StyleLoader.getDeclaredStyles(lines.subExtract(1, 1), styleBuilder)) {
                diagram.getSkinParam().muteStyle(modifiedStyle);
            }
            ((SkinParam)diagram.getSkinParam()).applyPendingStyleMigration();
            return CommandExecutionResult.ok();
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }
}

