/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.style.MergeStrategy;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.style.Value;
import znaishaded.net.sourceforge.plantuml.style.ValueColor;
import znaishaded.net.sourceforge.plantuml.style.ValueImpl;
import znaishaded.net.sourceforge.plantuml.style.ValueNull;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class Style {
    private final Map<PName, Value> map;
    private final StyleSignatureBasic signature;

    public Style(StyleSignatureBasic signature, Map<PName, Value> map) {
        this.map = map;
        this.signature = signature;
    }

    public Style deltaPriority(int delta) {
        if (!this.signature.isStarred()) {
            throw new UnsupportedOperationException();
        }
        EnumMap<PName, Value> copy = new EnumMap<PName, Value>(PName.class);
        for (Map.Entry<PName, Value> ent : this.map.entrySet()) {
            copy.put(ent.getKey(), ((ValueImpl)ent.getValue()).addPriority(delta));
        }
        return new Style(this.signature, copy);
    }

    public void printMe() {
        if (this.map.size() == 0) {
            return;
        }
        System.err.println(this.signature + " {");
        for (Map.Entry<PName, Value> ent : this.map.entrySet()) {
            System.err.println("  " + (Object)((Object)ent.getKey()) + ": " + ent.getValue().asString());
        }
        System.err.println("}");
    }

    public String toString() {
        return this.signature + " " + this.map;
    }

    public Value value(PName name) {
        Value result = this.map.get((Object)name);
        if (result == null) {
            return ValueNull.NULL;
        }
        return result;
    }

    public boolean hasValue(PName name) {
        return this.map.containsKey((Object)name);
    }

    public Style mergeWith(Style other, MergeStrategy strategy) {
        if (other == null) {
            return this;
        }
        EnumMap<PName, Value> both = new EnumMap<PName, Value>(this.map);
        for (Map.Entry<PName, Value> ent : other.map.entrySet()) {
            Value previous = this.map.get((Object)ent.getKey());
            if (previous != null && previous.getPriority() > 1000 && strategy == MergeStrategy.KEEP_EXISTING_VALUE_OF_STEREOTYPE) continue;
            PName key = ent.getKey();
            both.put(key, ((ValueImpl)ent.getValue()).mergeWith(previous));
        }
        return new Style(this.signature.mergeWith(other.getSignature()), both);
    }

    public Style eventuallyOverride(PName param, HColor color) {
        if (color == null) {
            return this;
        }
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(this.map);
        Value old = result.get((Object)param);
        result.put(param, new ValueColor(color, old.getPriority()));
        return new Style(this.signature, result);
    }

    public Style eventuallyOverride(PName param, double value) {
        return this.eventuallyOverride(param, "" + value);
    }

    public Style eventuallyOverride(PName param, String value) {
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(this.map);
        result.put(param, ValueImpl.regular(value, Integer.MAX_VALUE));
        return new Style(this.signature, result);
    }

    public Style eventuallyOverride(Colors colors) {
        Style result = this;
        if (colors != null) {
            HColor text;
            HColor line;
            HColor back = colors.getColor(ColorType.BACK);
            if (back != null) {
                result = result.eventuallyOverride(PName.BackGroundColor, back);
            }
            if ((line = colors.getColor(ColorType.LINE)) != null) {
                result = result.eventuallyOverride(PName.LineColor, line);
            }
            if ((text = colors.getColor(ColorType.TEXT)) != null) {
                result = result.eventuallyOverride(PName.FontColor, text);
            }
        }
        return result;
    }

    public Style eventuallyOverride(SymbolContext symbolContext) {
        HColor back;
        Style result = this;
        if (symbolContext != null && (back = symbolContext.getBackColor()) != null) {
            result = result.eventuallyOverride(PName.BackGroundColor, back);
        }
        return result;
    }

    public StyleSignatureBasic getSignature() {
        return this.signature;
    }

    public UFont getUFont() {
        String family = this.value(PName.FontName).asString();
        int fontStyle = this.value(PName.FontStyle).asFontStyle();
        int size = this.value(PName.FontSize).asInt();
        return new UFont(family, fontStyle, size);
    }

    public FontConfiguration getFontConfiguration(ThemeStyle themeStyle, HColorSet set) {
        return this.getFontConfiguration(themeStyle, set, null);
    }

    public FontConfiguration getFontConfiguration(ThemeStyle themeStyle, HColorSet set, Colors colors) {
        HColor color;
        UFont font = this.getUFont();
        HColor hColor = color = colors == null ? null : colors.getColor(ColorType.TEXT);
        if (color == null) {
            color = this.value(PName.FontColor).asColor(themeStyle, set);
        }
        HColor hyperlinkColor = this.value(PName.HyperLinkColor).asColor(themeStyle, set);
        return FontConfiguration.create(font, color, hyperlinkColor, true);
    }

    public SymbolContext getSymbolContext(ThemeStyle themeStyle, HColorSet set) {
        HColor backColor = this.value(PName.BackGroundColor).asColor(themeStyle, set);
        HColor foreColor = this.value(PName.LineColor).asColor(themeStyle, set);
        double deltaShadowing = this.value(PName.Shadowing).asDouble();
        return new SymbolContext(backColor, foreColor).withStroke(this.getStroke()).withDeltaShadow(deltaShadowing);
    }

    public Style eventuallyOverride(UStroke stroke) {
        if (stroke == null) {
            return this;
        }
        Style result = this.eventuallyOverride(PName.LineThickness, stroke.getThickness());
        double space = stroke.getDashSpace();
        double visible = stroke.getDashVisible();
        result = result.eventuallyOverride(PName.LineStyle, "" + visible + ";" + space);
        return result;
    }

    public UStroke getStroke() {
        double thickness = this.value(PName.LineThickness).asDouble();
        String dash = this.value(PName.LineStyle).asString();
        if (dash.length() == 0) {
            return new UStroke(thickness);
        }
        try {
            double dashVisible;
            StringTokenizer st = new StringTokenizer(dash, "-;,");
            double dashSpace = dashVisible = Double.parseDouble(st.nextToken().trim());
            if (st.hasMoreTokens()) {
                dashSpace = Double.parseDouble(st.nextToken().trim());
            }
            return new UStroke(dashVisible, dashSpace, thickness);
        }
        catch (Exception e) {
            return new UStroke(thickness);
        }
    }

    public UStroke getStroke(Colors colors) {
        UStroke stroke = colors.getSpecificLineStroke();
        if (stroke == null) {
            return this.getStroke();
        }
        return stroke;
    }

    public LineBreakStrategy wrapWidth() {
        String value = this.value(PName.MaximumWidth).asString();
        return new LineBreakStrategy(value);
    }

    public ClockwiseTopRightBottomLeft getPadding() {
        String padding = this.value(PName.Padding).asString();
        return ClockwiseTopRightBottomLeft.read(padding);
    }

    public ClockwiseTopRightBottomLeft getMargin() {
        String margin = this.value(PName.Margin).asString();
        return ClockwiseTopRightBottomLeft.read(margin);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.value(PName.HorizontalAlignment).asHorizontalAlignment();
    }

    private TextBlock createTextBlockInternal(Display display, HColorSet set, ISkinSimple spriteContainer, HorizontalAlignment alignment) {
        FontConfiguration fc = this.getFontConfiguration(spriteContainer.getThemeStyle(), set);
        return display.create(fc, alignment, spriteContainer);
    }

    public TextBlock createTextBlockBordered(Display note, HColorSet set, ISkinSimple spriteContainer) {
        HorizontalAlignment alignment = this.getHorizontalAlignment();
        TextBlock textBlock = this.createTextBlockInternal(note, set, spriteContainer, alignment);
        HColor backgroundColor = this.value(PName.BackGroundColor).asColor(spriteContainer.getThemeStyle(), set);
        HColor lineColor = this.value(PName.LineColor).asColor(spriteContainer.getThemeStyle(), set);
        UStroke stroke = this.getStroke();
        int cornersize = this.value(PName.RoundCorner).asInt();
        ClockwiseTopRightBottomLeft margin = this.getMargin();
        ClockwiseTopRightBottomLeft padding = this.getPadding();
        TextBlock result = TextBlockUtils.bordered(textBlock, stroke, lineColor, backgroundColor, cornersize, padding);
        return TextBlockUtils.withMargin(result, margin);
    }

    public UGraphic applyStrokeAndLineColor(UGraphic ug, HColorSet colorSet, ThemeStyle themeStyle) {
        HColor color = this.value(PName.LineColor).asColor(themeStyle, colorSet);
        ug = color == null ? ug.apply(new HColorNone()) : ug.apply(color);
        ug = ug.apply(this.getStroke());
        return ug;
    }
}

