/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.posimo.BezierUtils;
import znaishaded.net.sourceforge.plantuml.svek.PointDirected;
import znaishaded.net.sourceforge.plantuml.svek.Side;

public class ClusterPosition {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public ClusterPosition(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public boolean contains(double x, double y) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY;
    }

    public ClusterPosition merge(ClusterPosition other) {
        return new ClusterPosition(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY));
    }

    public ClusterPosition merge(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        return new ClusterPosition(Math.min(this.minX, x), Math.min(this.minY, y), Math.max(this.maxX, x), Math.max(this.maxY, y));
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public String toString() {
        return "minX=" + this.minX + " maxX=" + this.maxX + " minY=" + this.minY + " maxY=" + this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public PointDirected getIntersection(CubicCurve2D.Double bez) {
        if (this.contains(bez.x1, bez.y1) == this.contains(bez.x2, bez.y2)) {
            return null;
        }
        double dist = bez.getP1().distance(bez.getP2());
        if (dist < 2.0) {
            double angle = BezierUtils.getStartingAngle(bez);
            return new PointDirected(bez.getP1(), angle);
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        bez.subdivide(left, right);
        PointDirected int1 = this.getIntersection(left);
        if (int1 != null) {
            return int1;
        }
        PointDirected int2 = this.getIntersection(right);
        if (int2 != null) {
            return int2;
        }
        throw new IllegalStateException();
    }

    public Point2D getPointCenter() {
        return new Point2D.Double((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    public ClusterPosition withMinX(double d) {
        return new ClusterPosition(d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, d, this.maxY);
    }

    public ClusterPosition addMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + d, this.maxY);
    }

    public ClusterPosition addMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY + d);
    }

    public ClusterPosition addMinX(double d) {
        return new ClusterPosition(this.minX + d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition addMinY(double d) {
        return new ClusterPosition(this.minX, this.minY + d, this.maxX, this.maxY);
    }

    public ClusterPosition withMinY(double d) {
        return new ClusterPosition(this.minX, d, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, d);
    }

    public Point2D getProjectionOnFrontier(Point2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        if (x > this.maxX && y >= this.minY && y <= this.maxY) {
            return new Point2D.Double(this.maxX - 1.0, y);
        }
        if (x < this.minX && y >= this.minY && y <= this.maxY) {
            return new Point2D.Double(this.minX + 1.0, y);
        }
        if (y > this.maxY && x >= this.minX && x <= this.maxX) {
            return new Point2D.Double(x, this.maxY - 1.0);
        }
        if (y < this.minY && x >= this.minX && x <= this.maxX) {
            return new Point2D.Double(x, this.minY + 1.0);
        }
        return new Point2D.Double(x, y);
    }

    public ClusterPosition delta(double m1, double m22) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + m1, this.maxY + m22);
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
    }

    public boolean isPointJustUpper(Point2D pt) {
        return pt.getX() >= this.minX && pt.getX() <= this.maxX && pt.getY() <= this.minY;
    }

    public Side getClosestSide(Point2D pt) {
        double distEast;
        double distNorth = Math.abs(this.minY - pt.getY());
        double distSouth = Math.abs(this.maxY - pt.getY());
        double distWest = Math.abs(this.minX - pt.getX());
        if (this.isSmallerThan(distNorth, distWest, distEast = Math.abs(this.maxX - pt.getX()), distSouth)) {
            return Side.NORTH;
        }
        if (this.isSmallerThan(distSouth, distNorth, distWest, distEast)) {
            return Side.SOUTH;
        }
        if (this.isSmallerThan(distEast, distNorth, distWest, distSouth)) {
            return Side.EAST;
        }
        if (this.isSmallerThan(distWest, distNorth, distEast, distSouth)) {
            return Side.WEST;
        }
        return null;
    }

    private boolean isSmallerThan(double value, double a, double b, double c) {
        return value <= a && value <= b && value <= c;
    }
}

