/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.BaseFile;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Rankdir;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersions;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.posimo.Moveable;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ColorSequence;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;
import znaishaded.net.sourceforge.plantuml.svek.EmptySvgException;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekLine;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.SvekUtils;
import znaishaded.net.sourceforge.plantuml.svek.SvgResult;
import znaishaded.net.sourceforge.plantuml.svek.YDelta;
import znaishaded.net.sourceforge.plantuml.vizjs.GraphvizJs;
import znaishaded.net.sourceforge.plantuml.vizjs.GraphvizJsRuntimeException;

public class DotStringFactory
implements Moveable {
    private final Bibliotekon bibliotekon = new Bibliotekon();
    private final Set<String> rankMin = new HashSet<String>();
    private final ColorSequence colorSequence;
    private final Cluster root;
    private Cluster current;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final DotMode dotMode;
    private DotSplines dotSplines;
    private final StringBounder stringBounder;
    private GraphvizVersion graphvizVersion;

    public DotStringFactory(StringBounder stringBounder, DotData dotData) {
        this.skinParam = dotData.getSkinParam();
        this.umlDiagramType = dotData.getUmlDiagramType();
        this.dotMode = dotData.getDotMode();
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, dotData.getRootGroup());
    }

    public DotStringFactory(StringBounder stringBounder, CucaDiagram diagram) {
        this.skinParam = diagram.getSkinParam();
        this.umlDiagramType = diagram.getUmlDiagramType();
        this.dotMode = DotMode.NORMAL;
        this.colorSequence = new ColorSequence();
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(this.colorSequence, this.skinParam, diagram.getEntityFactory().getRootGroup());
    }

    public void addNode(SvekNode node) {
        this.current.addNode(node);
    }

    private void printMinRanking(StringBuilder sb) {
        if (this.rankMin.size() == 0) {
            return;
        }
        sb.append("{ rank = min;");
        for (String id : this.rankMin) {
            sb.append(id);
            sb.append(";");
        }
        sb.append("}");
    }

    private double getHorizontalDzeta() {
        double max = 0.0;
        for (SvekLine l : this.bibliotekon.allLines()) {
            double c = l.getHorizontalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    private double getVerticalDzeta() {
        double max = 0.0;
        for (SvekLine l : this.bibliotekon.allLines()) {
            double c = l.getVerticalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    String createDotString(String ... dotStrings) {
        StringBuilder sb = new StringBuilder();
        double nodesep = this.getHorizontalDzeta();
        if (nodesep < (double)this.getMinNodeSep()) {
            nodesep = this.getMinNodeSep();
        }
        if (this.skinParam.getNodesep() != 0.0) {
            nodesep = this.skinParam.getNodesep();
        }
        String nodesepInches = SvekUtils.pixelToInches(nodesep);
        double ranksep = this.getVerticalDzeta();
        if (ranksep < (double)this.getMinRankSep()) {
            ranksep = this.getMinRankSep();
        }
        if (this.skinParam.getRanksep() != 0.0) {
            ranksep = this.skinParam.getRanksep();
        }
        String ranksepInches = SvekUtils.pixelToInches(ranksep);
        sb.append("digraph unix {");
        SvekUtils.println(sb);
        for (String s2 : dotStrings) {
            if (s2.startsWith("ranksep")) {
                sb.append("ranksep=" + ranksepInches + ";");
            } else if (s2.startsWith("nodesep")) {
                sb.append("nodesep=" + nodesepInches + ";");
            } else {
                sb.append(s2);
            }
            SvekUtils.println(sb);
        }
        sb.append("remincross=true;");
        SvekUtils.println(sb);
        sb.append("searchsize=500;");
        SvekUtils.println(sb);
        this.dotSplines = this.skinParam.getDotSplines();
        if (this.dotSplines == DotSplines.POLYLINE) {
            sb.append("splines=polyline;");
            SvekUtils.println(sb);
        } else if (this.dotSplines == DotSplines.ORTHO) {
            sb.append("splines=ortho;");
            sb.append("forcelabels=true;");
            SvekUtils.println(sb);
        }
        if (this.skinParam.getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            sb.append("rankdir=LR;");
            SvekUtils.println(sb);
        }
        this.manageMinMaxCluster(sb);
        this.root.printCluster1(sb, this.bibliotekon.allLines(), this.stringBounder);
        for (SvekLine line : this.bibliotekon.lines0()) {
            line.appendLine(this.getGraphvizVersion(), sb, this.dotMode, this.dotSplines);
        }
        this.root.fillRankMin(this.rankMin);
        this.root.printCluster2(sb, this.bibliotekon.allLines(), this.stringBounder, this.dotMode, this.getGraphvizVersion(), this.umlDiagramType);
        this.printMinRanking(sb);
        for (SvekLine line : this.bibliotekon.lines1()) {
            line.appendLine(this.getGraphvizVersion(), sb, this.dotMode, this.dotSplines);
        }
        SvekUtils.println(sb);
        sb.append("}");
        return sb.toString();
    }

    private void manageMinMaxCluster(StringBuilder sb) {
        ArrayList<String> minPointCluster = new ArrayList<String>();
        ArrayList<String> maxPointCluster = new ArrayList<String>();
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            String maxPoint;
            String minPoint = cluster.getMinPoint(this.umlDiagramType);
            if (minPoint != null) {
                minPointCluster.add(minPoint);
            }
            if ((maxPoint = cluster.getMaxPoint(this.umlDiagramType)) == null) continue;
            maxPointCluster.add(maxPoint);
        }
        if (minPointCluster.size() > 0) {
            sb.append("{rank=min;");
            for (String s2 : minPointCluster) {
                sb.append(s2);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
        if (maxPointCluster.size() > 0) {
            sb.append("{rank=max;");
            for (String s2 : maxPointCluster) {
                sb.append(s2);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
    }

    private int getMinRankSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.umlDiagramType == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        if (this.graphvizVersion == null) {
            this.graphvizVersion = this.getGraphvizVersionInternal();
        }
        return this.graphvizVersion;
    }

    private GraphvizVersion getGraphvizVersionInternal() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "foo;", "svg");
        if (graphviz instanceof GraphvizJs) {
            return GraphvizJs.getGraphvizVersion(false);
        }
        File f = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(f);
    }

    public String getSvg(BaseFile basefile, String[] dotOptions) throws IOException {
        ByteArrayOutputStream baos;
        block5: {
            String dotString = this.createDotString(dotOptions);
            if (basefile != null) {
                SFile f = basefile.getTraceFile("svek.dot");
                SvekUtils.traceString(f, dotString);
            }
            Graphviz graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
            baos = new ByteArrayOutputStream();
            try {
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (state.differs(ProcessState.TERMINATED_OK())) {
                    throw new IllegalStateException("Timeout4 " + state, state.getCause());
                }
            }
            catch (GraphvizJsRuntimeException e) {
                System.err.println("GraphvizJsRuntimeException");
                this.graphvizVersion = GraphvizJs.getGraphvizVersion(true);
                dotString = this.createDotString(dotOptions);
                graphviz = GraphvizUtils.create(this.skinParam, dotString, "svg");
                baos = new ByteArrayOutputStream();
                ProcessState state = graphviz.createFile3(baos);
                baos.close();
                if (!state.differs(ProcessState.TERMINATED_OK())) break block5;
                throw new IllegalStateException("Timeout4 " + state, state.getCause());
            }
        }
        byte[] result = baos.toByteArray();
        String s2 = new String(result, StandardCharsets.UTF_8);
        if (basefile != null) {
            SFile f = basefile.getTraceFile("svek.svg");
            SvekUtils.traceString(f, s2);
        }
        return s2;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        if (graphviz instanceof GraphvizJs) {
            return false;
        }
        File dotExe = graphviz.getDotExe();
        return dotExe == null || !dotExe.isFile() || !dotExe.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(this.skinParam, "svg", new String[0]);
        return graphviz.getDotExe();
    }

    public void solve(boolean mergeIntricated, EntityFactory entityFactory, String svg) throws IOException, InterruptedException {
        double minY;
        double minX;
        if (svg.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pGraph = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher mGraph = pGraph.matcher(svg);
        if (!mGraph.find()) {
            throw new IllegalStateException();
        }
        int fullHeight = Integer.parseInt(mGraph.group(2));
        YDelta move = new YDelta(fullHeight);
        SvgResult svgResult = new SvgResult(svg, move);
        for (SvekNode node : this.bibliotekon.allNodes()) {
            int idx = svg.indexOf("<title>" + node.getUid() + "</title>");
            if (node.getType() == ShapeType.RECTANGLE || node.getType() == ShapeType.RECTANGLE_HTML_FOR_PORTS || node.getType() == ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE || node.getType() == ShapeType.FOLDER || node.getType() == ShapeType.DIAMOND) {
                List<Point2D.Double> points = svgResult.substring(idx).extractList("points=\"");
                double minY2 = SvekUtils.getMinY(points);
                double overscanX = node.getOverscanX(this.stringBounder);
                double minX2 = SvekUtils.getMinX(points);
                node.moveSvek(minX2, minY2);
                continue;
            }
            if (node.getType() == ShapeType.ROUND_RECTANGLE) {
                List<Point2D.Double> points;
                int idx2 = svg.indexOf("d=\"", idx + 1);
                idx = svg.indexOf("points=\"", idx + 1);
                if (idx2 != -1 && (idx == -1 || idx2 < idx)) {
                    points = svgResult.substring(idx2).extractList("d=\"");
                } else {
                    points = svgResult.substring(idx).extractList("points=\"");
                    for (int i = 0; i < 3; ++i) {
                        idx = svg.indexOf("points=\"", idx + 1);
                        points.addAll(svgResult.substring(idx).extractList("points=\""));
                    }
                }
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                node.moveSvek(minX, minY);
                continue;
            }
            if (node.getType() == ShapeType.OCTAGON || node.getType() == ShapeType.HEXAGON) {
                int starting = idx = svg.indexOf("points=\"", idx + 1);
                List<Point2D.Double> points = svgResult.substring(starting).extractList("points=\"");
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                node.moveSvek(minX, minY);
                node.setPolygon(minX, minY, points);
                continue;
            }
            if (node.getType() == ShapeType.CIRCLE || node.getType() == ShapeType.CIRCLE_IN_RECT || node.getType() == ShapeType.OVAL) {
                double cx = SvekUtils.getValue(svg, idx, "cx");
                double cy = SvekUtils.getValue(svg, idx, "cy") + (double)fullHeight;
                double rx = SvekUtils.getValue(svg, idx, "rx");
                double ry = SvekUtils.getValue(svg, idx, "ry");
                node.moveSvek(cx - rx, cy - ry);
                continue;
            }
            throw new IllegalStateException(node.getType().toString() + " " + node.getUid());
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            int idx;
            IGroup group;
            if (mergeIntricated && entityFactory.isIntricated(group = cluster.getGroups().iterator().next()) != null) continue;
            int starting = idx = this.getClusterIndex(svg, cluster.getColor());
            List<Point2D.Double> points = svgResult.substring(starting).extractList("points=\"");
            minX = SvekUtils.getMinX(points);
            minY = SvekUtils.getMinY(points);
            double maxX = SvekUtils.getMaxX(points);
            double maxY = SvekUtils.getMaxY(points);
            cluster.setPosition(minX, minY, maxX, maxY);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            int starting1 = idx = this.getClusterIndex(svg, cluster.getTitleColor());
            List<Point2D.Double> pointsTitle = svgResult.substring(starting1).extractList("points=\"");
            double minXtitle = SvekUtils.getMinX(pointsTitle);
            double minYtitle = SvekUtils.getMinY(pointsTitle);
            cluster.setTitlePosition(minXtitle, minYtitle);
        }
        for (SvekLine line : this.bibliotekon.allLines()) {
            line.solveLine(svgResult);
        }
        for (SvekLine line : this.bibliotekon.allLines()) {
            line.manageCollision(this.bibliotekon.allNodes());
        }
    }

    private int getClusterIndex(String svg, int colorInt) {
        String colorString = StringUtils.goLowerCase(StringUtils.sharp000000(colorInt));
        String keyTitle1 = "=\"" + colorString + "\"";
        int idx = svg.indexOf(keyTitle1);
        if (idx == -1) {
            String keyTitle2 = "stroke:" + colorString + ";";
            idx = svg.indexOf(keyTitle2);
        }
        if (idx == -1) {
            throw new IllegalStateException("Cannot find color " + colorString);
        }
        return idx;
    }

    public void openCluster(int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo, IGroup g2) {
        this.current = this.current.createChild(titleAndAttributeWidth, titleAndAttributeHeight, title, stereo, this.colorSequence, this.skinParam, g2);
        this.bibliotekon.addCluster(this.current);
    }

    public void closeCluster() {
        if (this.current.getParentCluster() == null) {
            throw new IllegalStateException();
        }
        this.current = this.current.getParentCluster();
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        for (SvekNode sh : this.bibliotekon.allNodes()) {
            sh.moveSvek(deltaX, deltaY);
        }
        for (SvekLine line : this.bibliotekon.allLines()) {
            line.moveSvek(deltaX, deltaY);
        }
        for (Cluster cl : this.bibliotekon.allCluster()) {
            cl.moveSvek(deltaX, deltaY);
        }
    }

    public final Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }

    public ColorSequence getColorSequence() {
        return this.colorSequence;
    }
}

