/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.HashSet;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotData;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.DotStringFactory;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekLine;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.Untranslated;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHidden;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public final class SvekResult
extends AbstractTextBlock
implements IEntityImage {
    private final Rose rose = new Rose();
    private final DotData dotData;
    private final DotStringFactory dotStringFactory;
    private MinMax minMax;

    public SvekResult(DotData dotData, DotStringFactory dotStringFactory) {
        this.dotData = dotData;
        this.dotStringFactory = dotStringFactory;
    }

    @Override
    public void drawU(UGraphic ug) {
        for (Cluster cluster : this.dotStringFactory.getBibliotekon().allCluster()) {
            cluster.drawU(ug, this.dotData.getUmlDiagramType(), this.dotData.getSkinParam());
        }
        Style style2 = this.getDefaultStyleDefinition(null).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        HColor color = style2.value(PName.LineColor).asColor(this.dotData.getSkinParam().getThemeStyle(), this.dotData.getSkinParam().getIHtmlColorSet());
        color = HColorUtils.noGradient(color);
        for (SvekNode node : this.dotStringFactory.getBibliotekon().allNodes()) {
            double minX = node.getMinX();
            double minY = node.getMinY();
            UGraphic ug2 = node.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            IEntityImage image = node.getImage();
            image.drawU(ug2.apply(new UTranslate(minX, minY)));
            if (!(image instanceof Untranslated)) continue;
            ((Untranslated)image).drawUntranslated(ug.apply(color), minX, minY);
        }
        HashSet<String> ids = new HashSet<String>();
        for (SvekLine line : this.dotStringFactory.getBibliotekon().allLines()) {
            UGraphic ug2 = line.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            StyleBuilder currentStyleBuilder = line.getCurrentStyleBuilder();
            Style styleLine = this.getDefaultStyleDefinition(line.getStereotype()).getMergedStyle(currentStyleBuilder);
            color = styleLine.value(PName.LineColor).asColor(this.dotData.getSkinParam().getThemeStyle(), this.dotData.getSkinParam().getIHtmlColorSet());
            color = HColorUtils.noGradient(color);
            line.drawU(ug2, styleLine.getStroke(), color, ids);
        }
    }

    private StyleSignature getDefaultStyleDefinition(Stereotype stereotype) {
        StyleSignatureBasic result = StyleSignatureBasic.of(SName.root, SName.element, this.dotData.getUmlDiagramType().getStyleName(), SName.arrow);
        return result.withTOBECHANGED(stereotype);
    }

    @Override
    public HColor getBackcolor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getThemeStyle(), this.dotData.getSkinParam().getIHtmlColorSet());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.minMax == null) {
            this.minMax = TextBlockUtils.getMinMax(this, stringBounder, false);
            this.dotStringFactory.moveSvek(6.0 - this.minMax.getMinX(), 6.0 - this.minMax.getMinY());
        }
        return Dimension2DDouble.delta(this.minMax.getDimension(), 0.0, 12.0);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

