/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.ugraphic.Shadowable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGroupType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;
    private final TextBlock desc;
    private TextBlock stereo;
    private final boolean hideText;
    private final Collection<Link> links;
    private final boolean useRankSame = this.getSkinParam().useRankSame();
    private final boolean fixCircleLabelOverlapping;
    private final Bibliotekon bibliotekon;
    private final SymbolContext ctx;

    public EntityImageDescription(ILeaf entity, ISkinParam skinParam2, PortionShower portionShower, Collection<Link> links, SName styleName, Bibliotekon bibliotekon) {
        super(entity, entity.getColors().mute(skinParam2));
        this.bibliotekon = bibliotekon;
        this.fixCircleLabelOverlapping = this.getSkinParam().fixCircleLabelOverlapping();
        this.links = links;
        USymbol symbol = this.getUSymbol(entity);
        this.shapeType = symbol == USymbols.FOLDER ? ShapeType.FOLDER : (symbol == USymbols.HEXAGON ? ShapeType.HEXAGON : (symbol == USymbols.INTERFACE ? (this.getSkinParam().fixCircleLabelOverlapping() ? ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE : ShapeType.RECTANGLE) : ShapeType.RECTANGLE));
        this.hideText = symbol == USymbols.INTERFACE;
        this.url = entity.getUrl99();
        Colors colors = entity.getColors();
        StyleSignatureBasic tmp = StyleSignatureBasic.of(SName.root, SName.element, styleName, symbol.getSName());
        Stereotype stereotype = entity.getStereotype();
        Style style = tmp.withTOBECHANGED(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder()).eventuallyOverride(colors);
        Style styleStereo = tmp.forStereotypeItself(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor forecolor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        }
        double roundCorner = style.value(PName.RoundCorner).asDouble();
        double diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        double deltaShadow = style.value(PName.Shadowing).asDouble();
        UStroke stroke = style.getStroke(colors);
        FontConfiguration fcTitle = style.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        FontConfiguration fcStereo = styleStereo.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment defaultAlign = style.getHorizontalAlignment();
        assert (this.getStereo() == stereotype);
        this.ctx = new SymbolContext(backcolor, forecolor).withStroke(stroke).withShadow(deltaShadow).withCorner(roundCorner, diagonalCorner);
        Display codeDisplay = Display.getWithNewlines(entity.getCodeGetName());
        if (entity.getDisplay().equals(codeDisplay) && symbol.getSName() == SName.package_ || entity.getDisplay().isWhite()) {
            this.desc = TextBlockUtils.empty(this.getSkinParam().minClassWidth(), 0.0);
        } else {
            HorizontalAlignment align = this.getSkinParam().getDefaultTextAlignment(defaultAlign);
            this.desc = BodyFactory.create3(entity.getDisplay(), this.getSkinParam(), align, fcTitle, this.getSkinParam().wrapWidth(), style);
        }
        this.stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite(this.getSkinParam()) != null) {
            this.stereo = stereotype.getSprite(this.getSkinParam());
        } else if (stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(fcStereo, HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(HorizontalAlignment.CENTER), codeDisplay, this.getSkinParam(), stereotype, entity, style);
        this.asSmall = this.hideText ? symbol.asSmall(TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), this.ctx, this.getSkinParam().getStereotypeAlignment()) : symbol.asSmall(this.name, this.desc, this.stereo, this.ctx, this.getSkinParam().getStereotypeAlignment());
    }

    private USymbol getUSymbol(ILeaf entity) {
        USymbol result = entity.getUSymbol() == null ? this.getSkinParam().componentStyle().toUSymbol() : entity.getUSymbol();
        return Objects.requireNonNull(result);
    }

    public Dimension2D getNameDimension(StringBounder stringBounder) {
        if (this.hideText) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.name.calculateDimension(stringBounder);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        if (!this.hideText) {
            return Margins.NONE;
        }
        if (this.isThereADoubleLink((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (!this.fixCircleLabelOverlapping && this.hasSomeHorizontalLinkVisible((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (this.hasSomeHorizontalLinkDoubleDecorated((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
        double x = Math.max(dimStereo.getWidth(), dimDesc.getWidth());
        double suppX = x - dimSmall.getWidth();
        if (suppX < 1.0) {
            suppX = 1.0;
        }
        double y = MathUtils.max(1.0, dimDesc.getHeight(), dimStereo.getHeight());
        return new Margins(suppX / 2.0, suppX / 2.0, y, y);
    }

    private boolean hasSomeHorizontalLinkVisible(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || link.isInvis()) continue;
            return true;
        }
        return false;
    }

    private boolean isThereADoubleLink(ILeaf leaf, Collection<Link> links) {
        HashSet<IEntity> others = new HashSet<IEntity>();
        for (Link link : links) {
            IEntity other;
            boolean changed;
            if (!link.contains(leaf) || (changed = others.add(other = link.getOther(leaf)))) continue;
            return true;
        }
        return false;
    }

    private boolean hasSomeHorizontalLinkDoubleDecorated(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || !link.getType().isDoubleDecorated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("entity " + this.getEntity().getCodeGetName()));
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.shapeType == ShapeType.HEXAGON) {
            this.drawHexagon(this.ctx.apply(ug));
        }
        this.asSmall.drawU(ug);
        if (this.hideText) {
            double space = 8.0;
            Dimension2D dimSmall = this.asSmall.calculateDimension(ug.getStringBounder());
            Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            UGraphic ugDesc = ug.apply(new UTranslate(posx1, 8.0 + dimSmall.getHeight()));
            ugDesc = UGraphicStencil.create(ugDesc, dimDesc);
            this.desc.drawU(ugDesc);
            Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(new UTranslate(posx2, -8.0 - dimStereo.getHeight())));
        }
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private void drawHexagon(UGraphic ug) {
        if (this.bibliotekon == null) {
            throw new IllegalStateException();
        }
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable hexagon = node.getPolygon();
        if (hexagon != null) {
            hexagon.setDeltaShadow(this.ctx.getDeltaShadow());
            ug.draw(hexagon);
        }
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        if (this.hideText) {
            Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
            Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
            Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            return MathUtils.max(-posx1, -posx2, 0.0);
        }
        return 0.0;
    }
}

