/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageStateBorder
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImageStateBorder(ILeaf leaf, ISkinParam skinParam, Cluster stateParent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, stateParent, bibliotekon, FontParam.STATE);
        this.sname = sname;
    }

    private StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname);
    }

    private boolean upPosition() {
        if (this.parent == null) {
            return false;
        }
        Point2D clusterCenter = this.parent.getClusterPosition().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public final void drawU(UGraphic ug) {
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(this.getUStroke()).apply(borderColor);
        ug = ug.apply(backcolor.bg());
        this.entityPosition.drawSymbol(ug, this.rankdir);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }
}

