/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.DefinitionsContainer;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.preproc.ImportedFiles;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.TMemoryGlobal;

public class TimLoader {
    private final TContext context;
    private final TMemory global = new TMemoryGlobal();
    private boolean preprocessorError;
    private List<StringLocated> resultList;

    public TimLoader(ImportedFiles importedFiles, Defines defines, Charset charset, DefinitionsContainer definitionsContainer) {
        this.context = new TContext(importedFiles, defines, charset, definitionsContainer);
        try {
            defines.copyTo(this.global);
        }
        catch (EaterException e) {
            e.printStackTrace();
        }
    }

    public Set<FileWithSuffix> load(List<StringLocated> list) {
        try {
            this.context.executeLines(this.global, list, null, false);
        }
        catch (EaterExceptionLocated e) {
            this.context.getResultList().add(e.getLocation().withErrorPreprocessor(e.getMessage()));
            this.changeLastLine(this.context.getDebug(), e.getMessage());
            this.preprocessorError = true;
        }
        this.resultList = this.context.getResultList();
        return this.context.getFilesUsedCurrent();
    }

    private void changeLastLine(List<StringLocated> list, String message) {
        int num = list.size() - 1;
        StringLocated last = list.get(num);
        list.set(num, last.withErrorPreprocessor(message));
    }

    public final List<StringLocated> getResultList() {
        return this.resultList;
    }

    public final List<StringLocated> getDebug() {
        return this.context.getDebug();
    }

    public final boolean isPreprocessorError() {
        return this.preprocessorError;
    }
}

