/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.json.ParseException;
import znaishaded.net.sourceforge.plantuml.tim.EaterAffectation;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TLineType;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import znaishaded.net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorAffectation
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorAffectation(CodeIterator source, TContext context, TMemory memory, List<StringLocated> log) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = log;
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (result.getType() != TLineType.AFFECTATION) break;
            this.logs.add(result);
            this.doAffectation(result);
            this.next();
        }
        return result;
    }

    private void doAffectation(StringLocated result) throws EaterException, EaterExceptionLocated {
        int lastLocation = -1;
        for (int i = 0; i < 9999; ++i) {
            try {
                this.executeAffectation(this.context, this.memory, result);
                return;
            }
            catch (ParseException e) {
                if (e.getColumn() <= lastLocation) {
                    throw EaterException.located("Error in JSON format");
                }
                lastLocation = e.getColumn();
                this.next();
                StringLocated forward = this.source.peek();
                result = result.append(forward.getString());
                continue;
            }
        }
    }

    private void executeAffectation(TContext context, TMemory memory, StringLocated s2) throws EaterException, EaterExceptionLocated {
        new EaterAffectation(s2).analyze(context, memory);
    }
}

