/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeAxisStategy;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingFormat;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class TimingRuler {
    private final SortedSet<TimeTick> times = new TreeSet<TimeTick>();
    private final ISkinParam skinParam;
    private long tickIntervalInPixels = 50L;
    private long tickUnitary;
    private TimingFormat format = TimingFormat.DECIMAL;
    private long highestCommonFactorInternal = -1L;

    static UGraphic applyForVLines(UGraphic ug, Style style, ISkinParam skinParam) {
        UStroke stroke = new UStroke(3.0, 5.0, 0.5);
        HColor color = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        return ug.apply(stroke).apply(color);
    }

    public void ensureNotEmpty() {
        if (this.times.size() == 0) {
            this.times.add(new TimeTick(BigDecimal.ZERO, TimingFormat.DECIMAL));
        }
        if (this.getMax().getTime().signum() > 0 && this.getMin().getTime().signum() < 0) {
            this.times.add(new TimeTick(BigDecimal.ZERO, TimingFormat.DECIMAL));
        }
    }

    public TimingRuler(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public void scaleInPixels(long tick, long pixel) {
        if (pixel <= 0L || tick <= 0L) {
            throw new IllegalArgumentException();
        }
        this.tickIntervalInPixels = pixel;
        this.tickUnitary = tick;
    }

    private long tickUnitary() {
        if (this.tickUnitary == 0L) {
            return this.highestCommonFactor();
        }
        return this.tickUnitary;
    }

    private long highestCommonFactor() {
        if (this.highestCommonFactorInternal == -1L) {
            for (long tick : this.getAbsolutesTicks()) {
                if (this.highestCommonFactorInternal == -1L) {
                    this.highestCommonFactorInternal = tick;
                    continue;
                }
                long candidate = TimingRuler.computeHighestCommonFactor(this.highestCommonFactorInternal, tick);
                double size = (this.getMax().getTime().doubleValue() - this.getMin().getTime().doubleValue()) / (double)candidate;
                if (size > 200.0) {
                    return this.highestCommonFactorInternal;
                }
                this.highestCommonFactorInternal = candidate;
            }
        }
        return this.highestCommonFactorInternal;
    }

    private Set<Long> getAbsolutesTicks() {
        TreeSet<Long> result = new TreeSet<Long>(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o2.compareTo(o1);
            }
        });
        for (TimeTick time : this.times) {
            long value = Math.abs(time.getTime().longValue());
            if (value <= 0L) continue;
            result.add(value);
        }
        return result;
    }

    private int getNbTick() {
        if (this.times.size() == 0) {
            return 1;
        }
        long delta = this.getMax().getTime().longValue() - this.getMin().getTime().longValue();
        return Math.min(1000, (int)(1L + delta / this.tickUnitary()));
    }

    public double getWidth() {
        double delta = this.getMax().getTime().doubleValue() - this.getMin().getTime().doubleValue();
        return (delta / (double)this.tickUnitary() + 1.0) * (double)this.tickIntervalInPixels;
    }

    public final double getPosInPixel(TimeTick when) {
        return this.getPosInPixelInternal(when.getTime().doubleValue());
    }

    private double getPosInPixelInternal(double time) {
        return (time -= this.getMin().getTime().doubleValue()) / (double)this.tickUnitary() * (double)this.tickIntervalInPixels;
    }

    private long tickToTime(int i) {
        return this.tickUnitary * (long)i + this.getMin().getTime().longValue();
    }

    public void addTime(TimeTick time) {
        this.highestCommonFactorInternal = -1L;
        this.times.add(time);
        if (time.getFormat() != TimingFormat.DECIMAL) {
            this.format = time.getFormat();
        }
    }

    private FontConfiguration getFontConfiguration() {
        return FontConfiguration.create(this.skinParam, this.getStyle());
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.timeline).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private TextBlock getTimeTextBlock(long time) {
        return this.getTimeTextBlock(this.format.formatTime(time));
    }

    private TextBlock getTimeTextBlock(String string) {
        Display display = Display.getWithNewlines(string);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawTimeAxis(UGraphic ug, TimeAxisStategy timeAxisStategy, Map<String, TimeTick> codes) {
        if (timeAxisStategy == TimeAxisStategy.HIDDEN) {
            return;
        }
        Style style = StyleSignatureBasic.of(SName.root, SName.timingDiagram, SName.timeline).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor color = style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        ug = ug.apply(stroke).apply(color);
        if (timeAxisStategy == TimeAxisStategy.AUTOMATIC) {
            this.drawTimeAxisAutomatic(ug);
        } else {
            this.drawTimeAxisManual(ug, codes);
        }
    }

    private void drawTimeAxisManual(UGraphic ug, Map<String, TimeTick> codes) {
        double tickHeight = 5.0;
        ULine line = ULine.vline(5.0);
        double firstTickPosition = this.getPosInPixelInternal(this.getFirstPositiveOrZeroValue().doubleValue());
        int nb = 0;
        while (firstTickPosition + (double)((long)nb * this.tickIntervalInPixels) <= this.getWidth()) {
            ++nb;
        }
        ug.apply(UTranslate.dx(firstTickPosition)).draw(ULine.hline((long)(nb - 1) * this.tickIntervalInPixels));
        for (TimeTick tick : this.times) {
            ug.apply(UTranslate.dx(this.getPosInPixel(tick))).draw(line);
            String label = this.getLabel(tick, codes);
            if (label.length() == 0) continue;
            TextBlock text = this.getTimeTextBlock(label);
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(this.getPosInPixel(tick) - dim.getWidth() / 2.0, 6.0)));
        }
    }

    private void drawTimeAxisAutomatic(UGraphic ug) {
        double tickHeight = 5.0;
        ULine line = ULine.vline(5.0);
        double firstTickPosition = this.getPosInPixelInternal(this.getFirstPositiveOrZeroValue().doubleValue());
        int nb = 0;
        while (firstTickPosition + (double)((long)nb * this.tickIntervalInPixels) <= this.getWidth()) {
            ug.apply(UTranslate.dx(firstTickPosition + (double)((long)nb * this.tickIntervalInPixels))).draw(line);
            ++nb;
        }
        ug.apply(UTranslate.dx(firstTickPosition)).draw(ULine.hline((long)(nb - 1) * this.tickIntervalInPixels));
        for (long round : this.roundValues()) {
            TextBlock text = this.getTimeTextBlock(round);
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(this.getPosInPixelInternal(round) - dim.getWidth() / 2.0, 6.0)));
        }
    }

    private String getLabel(TimeTick tick, Map<String, TimeTick> codes) {
        for (Map.Entry<String, TimeTick> ent : codes.entrySet()) {
            if (!tick.equals(ent.getValue())) continue;
            return ent.getKey();
        }
        return this.format.formatTime(tick.getTime());
    }

    private BigDecimal getFirstPositiveOrZeroValue() {
        for (TimeTick time : this.times) {
            if (time.getTime().signum() < 0) continue;
            return time.getTime();
        }
        throw new IllegalStateException();
    }

    private Collection<Long> roundValues() {
        TreeSet<Long> result = new TreeSet<Long>();
        if (this.tickUnitary == 0L) {
            for (TimeTick tick : this.times) {
                long round = tick.getTime().longValue();
                result.add(round);
            }
        } else {
            int nb = this.getNbTick();
            for (int i = 0; i <= nb; ++i) {
                long round = this.tickToTime(i);
                result.add(round);
            }
        }
        if ((Long)result.first() < 0L && (Long)result.last() > 0L) {
            result.add(0L);
        }
        return result;
    }

    public void drawVlines(UGraphic ug, double height) {
        ug = TimingRuler.applyForVLines(ug, this.getStyle(), this.skinParam);
        ULine line = ULine.vline(height);
        int nb = this.getNbTick();
        for (int i = 0; i <= nb; ++i) {
            ug.apply(UTranslate.dx(this.tickIntervalInPixels * (long)i)).draw(line);
        }
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTimeTextBlock(0L).calculateDimension(stringBounder).getHeight();
    }

    private TimeTick getMax() {
        return this.times.last();
    }

    private TimeTick getMin() {
        return this.times.first();
    }

    private static long computeHighestCommonFactor(long a, long b) {
        long r = a;
        while (r != 0L) {
            r = a % b;
            a = b;
            b = r;
        }
        return Math.abs(a);
    }
}

